function [ features ] = fwpt( seg, PCG )
%FWPT Summary of this function goes here
%   Detailed explanation goes here


assigned_states=seg;


indx = find(abs(diff(assigned_states))>0); % find the locations with changed states

if assigned_states(1)>0   % for some recordings, there are state zeros at the beginning of assigned_states
    switch assigned_states(1)
        case 4
            K=1;
        case 3
            K=2;
        case 2
            K=3;
        case 1
            K=4;
    end
else
    switch assigned_states(indx(1)+1)
        case 4
            K=1;
        case 3
            K=2;
        case 2
            K=3;
        case 1
            K=0;
    end
    K=K+1;
end

indx2                = indx(K:end);
rem                  = mod(length(indx2),4);
indx2(end-rem+1:end) = [];
A                    = reshape(indx2,4,length(indx2)/4)';
A=A*2;

PCG=PCG/max(abs(PCG));

rows=28;
cols=28;

SS=zeros(size(A,1)-1,rows*cols);



for i=1:size(A,1)-1

    SS(i:i,1:rows*cols)=waveen(PCG(A(i,1):A(i+1,1)),rows,cols);

end

m_SS=mean(SS);



    function normen=waveen(signal,row,col)
        windowsize = 128;
        window = hanning(windowsize);
        nfft = windowsize;
        noverlap = windowsize-32;
        fs=2000;
        S = spectrogram(signal,window,noverlap,nfft,fs);
        S=abs(S);
        S(find(S<0.00001))=0.00001;
        S=log(abs(S));
        if size(S,2)==1
            S=repmat(S,1,2);
        end
        normen=resizeim(S,[row,col]);
        normen=normen(1:row*col);
    end


features=m_SS;
aaa=max(max(features));
bbb=min(min(features));
features=(features-bbb)/(aaa-bbb);

end

