function classifyResult = challenge(recordName)
%
% Sample entry for the 2016 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     1 = abnormal recording
%                    -1 = normal recording
%                     0 = unsure (too noisy)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2016/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu, Fubruary 21 2016
%             chengyu.liu@emory.edu
%
% Last modified by:
%
%

%% Load the trained parameter matrices for Springer's HSMM model.
% The parameters were trained using 409 heart sounds from MIT heart
% sound database, i.e., recordings a0001-a0409.
load('Springer_B_matrix.mat');
load('Springer_pi_vector.mat');
load('Springer_total_obs_distribution.mat');

%% Load data and resample data
springer_options   = default_Springer_HSMM_options;
[PCG, Fs1, nbits1] = wavread([recordName '.wav']);  % load data
if length(PCG)>50000
   PCG=PCG(1:50000);
end
% load(['/home/j/PhysioNet/datas/seg-v/' recordName(length(recordName)-5:length(recordName)) '.mat']);
% assigned_states=seg;
PCG_resampled      = resample(PCG,springer_options.audio_Fs,Fs1); % resample to springer_options.audio_Fs (1000 Hz)

%% Running runSpringerSegmentationAlgorithm.m to obtain the assigned_states
[assigned_states] = runSpringerSegmentationAlgorithm(PCG_resampled, springer_options.audio_Fs, Springer_B_matrix, Springer_pi_vector, Springer_total_obs_distribution, false); % obtain the locations for S1, systole, s2 and diastole

%% Running extractFeaturesFromHsIntervals.m to obtain the features for normal/abnormal heart sound classificaiton
%features  = extractFeaturesFromHsIntervals(assigned_states,PCG_resampled);
[b,a]=butter(5,0.05,'high');
PCG=filter(b,a,PCG);
features  = fwpt(assigned_states,PCG);
%load('cnn.mat');
%features=reshape(features,28,28);
%ff=zeros(28,28,2);
%ff(1:28,1:28,1:1)=features(1:28,1:28);
%ff(1:28,1:28,2:2)=features(1:28,1:28);
%net = cnnff(cnn, ff);
%features=net.fv';
%features=features(1:1,:);

%[~,h]=max(net.o);
%if h(1)==1
%   labels=-1;
%else
%   labels=1;
%end
save('features.mat','features');
system('python3 predict.py');
delete('features.mat');
load('labels.mat');
delete('labels.mat');
classifyResult=labels;

%% Running classifyFromHsIntervals.m to obtain the final classification result for the current recording
%classifyResult = classifyFromHsIntervals(features);
