function [classifyResult,features] = challenge(recordName)
%
% Sample entry for the 2016 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     1 = abnormal recording
%                    -1 = normal recording
%                     0 = unsure (too noisy)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2016/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu, Fubruary 21 2016
%             chengyu.liu@emory.edu
%
% Last modified by: Chengyu Liu, April 3 2016
%             Note: using 'audioread' to replace the 'wavread' function to load the .wav data.
%
%

% %% Load the trained parameter matrices for Springer's HSMM model.
% % The parameters were trained using 409 heart sounds from MIT heart
% % sound database, i.e., recordings a0001-a0409.
% load('Springer_B_matrix.mat');
% load('Springer_pi_vector.mat');
% load('Springer_total_obs_distribution.mat');
% 
% %% Load data and resample data
% springer_options   = default_Springer_HSMM_options;
% [PCG, Fs1, nbits1]         = wavread([recordName '.wav']);  % load data
% PCG_resampled      = resample(PCG,springer_options.audio_Fs,Fs1); % resample to springer_options.audio_Fs (1000 Hz)
% 
% %% Running runSpringerSegmentationAlgorithm.m to obtain the assigned_states
% [assigned_states] = runSpringerSegmentationAlgorithm(PCG_resampled, springer_options.audio_Fs, Springer_B_matrix, Springer_pi_vector, Springer_total_obs_distribution, false); % obtain the locations for S1, systole, s2 and diastole
% 
% %% Running extractFeaturesFromHsIntervals.m to obtain the features for normal/abnormal heart sound classificaiton
% features  = extractFeaturesFromHsIntervals(assigned_states,PCG_resampled);

%%% Running classifyFromHsIntervals.m to obtain the final classification result for the current recording
%classifyResult = classifyFromHsIntervals(features);

%% Extract 12 features by using audio analysis methods and 4 features by using find peaks segmentation
win = 0.050;
step = 0.050;
features = statistics_of_features(recordName,win,step);

%% Using extreme learning machine to obtain the final classificaiton result for the current recording

%% Using extreme learning machine and support vector machine to obtain the final classificaiton result for the current recording
dummyY = 1; c = 1000; g = 10;
load selFeature23.mat; sel = FeatureIndex_RFE(1:17); load Feature_Set23.mat; Ftrain = Set23(:,[1 sel+1]);
%load selFeature22.mat; sel = FeatureIndex_RFE(1:12); load Feature_Set22.mat; Ftrain = Set22(:,[1 sel+1]);
%load selFeature2.mat; sel = FeatureIndex_RFE(1:8); load Feature_Set2.mat; Ftrain = Set2(:,[1 sel+1]);
%extreme learning machine
%Ftest = [dummyY features(sel)];
%[TrainingTime, TestingTime, classifyResult1] = welm_kernel(Ftrain, Ftest, 1/g, c); 
%[TrainingTime, TestingTime, TrnA, TstA, classifyResult1] = elm_kernel(Ftrain, Ftest, 1, c, 'RBF_kernel',1/g); 
%support vector machine
load svm_model_17.mat
testy = dummyY; testx = features(sel); 
[T, classifyResult2, accuracy, dec_values] = evalc('svmpredict(testy, testx, model)'); 

%classifyResult = (classifyResult1 + classifyResult2)/2;

classifyResult = classifyResult2; 








