require 'optim'

function configureSetting(option)
  --print '==> Defining loss'

  if option.class_weight_switch then
    if table.getn(option.class_weight) ~= 6 then
      error("Class weight should be an 1-by-6 table")
    else
      weight = torch.Tensor(6)
      weight[1] = option.class_weight[1]
      weight[2] = option.class_weight[2]
      weight[3] = option.class_weight[3]
      weight[4] = option.class_weight[4]
      weight[5] = option.class_weight[5]
      weight[6] = option.class_weight[6]
    end

    --require 'ClassNLLCriterion_HH'
    --print('ClassNLLCriterion_HH')
    --criterion = nn.ClassNLLCriterion_HH(weight)
    --print('ClassNLLCriterion_HH')
  else
    --weightforclass=torch.Tensor(3)
    --weightforclass[1]=1
    --weightforclass[2]=1
    --weightforclass[3]=2.5
    --criterion = nn.ClassNLLCriterion(weightforclass)
    criterion = nn.ClassNLLCriterion()
  end
 -- criterion:cuda()
  ----------------------------------------------------------------------
  --print '==> Defining some tools'

  classes = {'Normal','Uncertain','Abnormal'}
  confusion = optim.ConfusionMatrix(classes)
  ----------------------------------------------------------------------
  --print '==> configuring optimizer'

  optimState = {
    learningRate = option.lr,
    weightDecay = 0.0005,
    momentum = option.momentum,
    learningRateDecay = option.lr_decay
  }
  optimMethod = optim.sgd
  ----------------------------------------------------------------------
  --print '==> Defining training procedure'

  --parameters, gradParameters = model:getParameters()
  batchsize = option.batchsize
  max_iter = option.max_iter
  -- max_upIter = option.max_upIter
  -- max_iter = math.floor(max_upIter/math.floor(nTraining/batchsize))
end
