function createClassificationInputData(recname)

  ## assumes there is a file recname.mat
  ## returns specgram data from recname and saves it to a file to be
  ## used by the neuralnetwork

  newfs=200;
  Fs=2000;

  printf("%s\n",[recname,".mat"])

  load([recname,".mat"])
  signal=data;
  signal(isnan(signal))=-5;

  LLL=length(signal)
  subsamplingrate=ceil(Fs/newfs)
  sig=resample(double(signal),newfs,Fs);


  ## should it really be done
  ## normalize amplitude
  ## attention a higher heart rate will imply a reduction in the amplitude
  ## after normalization!!!!!!!
  m=median(sig);
  if(m>1e-3)
    sig/= median(sig);
  endif

  ## this values where chosen for sampling frequency=200Hz
  window=32;
  step=8; # sampling frequency of specgrams=25Hz if newfs=2000Hz


  S=abs(specgram(sig,window,newfs,window,window-step));
  assert(!any(isnan(signal)));

  L=size(S,2); # number of timesteps in the spectrogram 
  radius=3; # newfs=200 step=8

  ## use only the middle range of frequencies
  n=size(S,1);
  k=floor(n/4);
  S=S(k+1:end,:); # dont use very low frequencies

  fname=[recname,"_spectrogram.mat"];
  save("-mat",fname,"S")
