function features = extractFeaturesFromHsIntervals(assigned_states, PCG)
%
% This function calculate 20 features based on the assigned_states by running "runSpringerSegmentationAlgorithm.m" function
%
% INPUTS:
% assigned_states: the array of state values assigned to the sound recording.
% PCG: resampled sound recording with 1000 Hz.
%
% OUTPUTS:
% features: the obtained 20 features for the current sound recording
%
%
% Written by: Chengyu Liu, January 22 2016
%             chengyu.liu@emory.edu
%
% Last modified by:
%
%
% $$$$$$ IMPORTANT
% Please note: the calculated 20 features are only some pilot features, some features maybe
% helpful for classifying normal/abnormal heart sounds, some maybe
% not. You need re-construct the features for a more accurate classification.


%% We just assume that the assigned_states cover at least 2 whole heart beat cycle
indx = find(abs(diff(assigned_states))>0); % find the locations with changed states

if assigned_states(1)>0   % for some recordings, there are state zeros at the beginning of assigned_states
    switch assigned_states(1)
        case 4
            K=1;
        case 3
            K=2;
        case 2
            K=3;
        case 1
            K=4;
    end
else
    switch assigned_states(indx(1)+1)
        case 4
            K=1;
        case 3
            K=2;
        case 2
            K=3;
        case 1
            K=0;
    end
    K=K+1;
end

indx2                = indx(K:end);
rem                  = mod(length(indx2),4);
indx2(end-rem+1:end) = [];
A                    = reshape(indx2,4,length(indx2)/4)'; % A is N*4 matrix, the 4 columns save the beginnings of S1, systole, S2 and diastole in the same heart cycle respectively

%% Parametros de entropia

features = [];

for kk=2:5
    
    % Orden
    ope = kk;
    % Retardo
    rpe = 1;

    % Entropia de permutacion de los tamaos de los tramos
    [HPE,PE,PEnormPCG]    = petropy(PCG,ope,rpe);
    [HPE,PE,PEnormRR]     = petropy(diff(A(:,1)),ope,rpe);
    [HPE,PE,PEnormIntS1]  = petropy(A(:,2)-A(:,1),ope,rpe);
    [HPE,PE,PEnormIntSys] = petropy(A(:,3)-A(:,2),ope,rpe);
    [HPE,PE,PEnormIntS2]  = petropy(A(:,4)-A(:,3),ope,rpe);
    [HPE,PE,PEnormIntDia] = petropy(A(2:end,1)-A(1:end-1,4),ope,rpe);

    for i=1:size(A,1)-1
    
        % Entropia de permutacin de los tramos
        [HPE,PE,PEnormP_S1(i)]     = petropy(PCG(A(i,1):A(i,2)),ope,rpe);
        [HPE,PE,PEnormP_Sys(i)]    = petropy(PCG(A(i,2):A(i,3)),ope,rpe);
        [HPE,PE,PEnormP_S2(i)]     = petropy(PCG(A(i,3):A(i,4)),ope,rpe);
        [HPE,PE,PEnormP_Dia(i)]    = petropy(PCG(A(i,4):A(i+1,1)),ope,rpe);
    
    end
    m_PEnormP_S1 = mean(PEnormP_S1);
    v_PEnormP_S1 = std(PEnormP_S1);
    m_PEnormP_Sys = mean(PEnormP_Sys);
    v_PEnormP_Sys = std(PEnormP_Sys);
    m_PEnormP_S2 = mean(PEnormP_S2);
    v_PEnormP_S2 = std(PEnormP_S2);
    m_PEnormP_Dia = mean(PEnormP_Dia);
    v_PEnormP_Dia = std(PEnormP_Dia);


    feat = [PEnormPCG PEnormRR PEnormIntS1 PEnormIntSys PEnormIntS2 PEnormIntDia ...
                m_PEnormP_S1 v_PEnormP_S1 m_PEnormP_Sys v_PEnormP_Sys ...
                m_PEnormP_S2 v_PEnormP_S2 m_PEnormP_Dia v_PEnormP_Dia];
            
    features = [features feat];
    
end




