function classifyResult = challenge(recordName)

% Sample entry for the 2016 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     1 = abnormal recording
%                    -1 = normal recording
%                     0 = unsure (too noisy)

sampleRate = 2000; %sample rate of pcg recordings
maxDuration = 10; %limit recording to this duration (s) if longer

scale=1.7; %wavelet scale
wname='gaus4';
entropyThreshold = 8.2;

%load phono recording
%phono = wavread([recordName,'.wav']);
[phono, ~] = audioread([recordName,'.wav']);
%limit duration if greater than maxDuration
if length(phono) > maxDuration*sampleRate
    phono = phono(1:maxDuration*sampleRate);
end
%remove mean
phono = phono-mean(phono);

%wavelet coefficients and energy
coefs=cwt(phono,scale,wname);
energy = abs(coefs.*coefs);
%wavelet entropy
energydistScale = energy/sum(energy);
entropyScale=-sum(energydistScale.*log(energydistScale));
if entropyScale > entropyThreshold
    classifyResult = -1;
else
    classifyResult = 1;
end
return;