def get_model(input_shape,num=1,drop_out = 0.5):
    from keras.layers.core import Dense, Flatten,Merge,Dropout
    from keras.layers.convolutional import Convolution1D, MaxPooling1D
    from keras.layers.recurrent import LSTM
    from keras.layers import Input, Dense, merge
    from keras.models import Model

    
    
    hidden_units = 32
    dense = 8
    print('Evaluate model...')

    Input_ = Input(shape=input_shape)
        
    cnn1 = Convolution1D(nb_filter=32,
                            filter_length=64,
                            border_mode='valid',
                            activation='relu',
                            subsample_length=4)(Input_)
    
    cnn2 = MaxPooling1D(pool_length=8)(cnn1)
    cnn3 = Convolution1D(nb_filter=32,
                            filter_length=16,
                            border_mode='valid',
                            activation='relu',
                            subsample_length=4)(cnn2)
    cnn4 = MaxPooling1D(pool_length=2)(cnn3)
    cnn_predictions = Flatten()(cnn4)
    cnn_predictions = Dense(hidden_units,activation='relu')(cnn_predictions)
    cnn_predictions = Dense(hidden_units,activation='relu')(cnn_predictions)
    
    
    rnn1 = LSTM(hidden_units,return_sequences=True)(cnn4)
    rnn2 = LSTM(hidden_units,return_sequences=True)(rnn1)
    rnn3 = LSTM(hidden_units,return_sequences=False)(rnn2)
    rnn_predictions = Dense(hidden_units,activation='relu')(rnn3)
    rnn_predictions = Dense(hidden_units,activation='relu')(rnn_predictions)
     
    rnn1_r = LSTM(hidden_units,return_sequences=True,go_backwards = True)(cnn4)
    rnn2_r = LSTM(hidden_units,return_sequences=True,go_backwards = True)(rnn1_r)
    rnn3_r = LSTM(hidden_units,return_sequences=False,go_backwards = True)(rnn2_r)
    rnn_r_predictions = Dense(hidden_units,activation='relu')(rnn3_r)
    rnn_r_predictions = Dense(hidden_units,activation='relu')(rnn_r_predictions)

    
    bi1_merge = merge([rnn1,rnn1_r], mode='concat', concat_axis=-1)
    bi2_f = LSTM(hidden_units,return_sequences=True)(bi1_merge)
    bi2_r = LSTM(hidden_units,return_sequences=True,go_backwards = True)(bi1_merge)
    bi2_merge = merge([bi2_f,bi2_r], mode='concat', concat_axis=-1)
    bi3_f = LSTM(hidden_units,return_sequences=True)(bi2_merge)
    bi3_r = LSTM(hidden_units,return_sequences=True,go_backwards = True)(bi2_merge)
    bi3_merge = merge([bi3_f,bi3_r], mode='concat', concat_axis=-1)
    rnn_bi_predictions = Flatten()(bi3_merge)
    rnn_bi_predictions = Dense(hidden_units,activation='relu')(rnn_bi_predictions)
    rnn_bi_predictions = Dense(dense,activation='relu')(rnn_bi_predictions)
    
    
    
    
    merge = merge([cnn_predictions,rnn_predictions,rnn_bi_predictions], mode='concat', concat_axis=-1)
        
    predictions = Dense(hidden_units, activation='relu')(merge)
    predictions = Dense(hidden_units, activation='relu')(predictions)
    predictions = Dense(1, activation='sigmoid')(predictions)

    model = Model(input=Input_, output=predictions)
    model.compile(optimizer='rmsprop',
              loss='binary_crossentropy',
              metrics=['accuracy'])
    return model
