clear all; close all;
%# read some training data
%[labels,data] = libsvmread('train.3');
load ('D:\phd\challenges\physionet\2016\data\training\training-e\features_e.mat');
data = features; labels = train_labels;
mindata = min(data);
maxdata = max(data);
rows = ones(size(data,1),1);
scaleddata = -1+2*(data-rows*mindata) ./ (rows*(maxdata-mindata));
save('scaledfactors.mat', 'mindata', 'maxdata');
%# grid of parameters
folds = 5;
[C,gamma] = meshgrid(-5:2:15, -15:2:3);

%# grid search, and cross-validation
cv_acc = zeros(numel(C),1);
for i=1:numel(C)
    cv_acc(i) = svmtrain(labels, scaleddata, ...
                    sprintf('-c %f -g %f -v %d', 2^C(i), 2^gamma(i), folds));
end

%# pair (C,gamma) with best accuracy
[~,idx] = max(cv_acc);

%# contour plot of paramter selection
contour(C, gamma, reshape(cv_acc,size(C))), colorbar
hold on
plot(C(idx), gamma(idx), 'rx')
text(C(idx), gamma(idx), sprintf('Acc = %.2f %%',cv_acc(idx)), ...
    'HorizontalAlign','left', 'VerticalAlign','top')
hold off
xlabel('log_2(C)'), ylabel('log_2(\gamma)'), title('Cross-Validation Accuracy')

%# now you can train you model using best_C and best_gamma
best_C = 2^C(idx);
best_gamma = 2^gamma(idx);
%# ...
m= svmtrain(labels, scaleddata, sprintf('-c %f -g %f', best_C, best_gamma));
                
%[labels,data] = libsvmread('test.3');
load ('D:\phd\challenges\physionet\2016\data\training\training-a\features_a.mat');
data = features; labels = train_labels;
rows = ones(size(data,1),1);
scaleddata = -1+2*(data-rows*mindata) ./ (rows*(maxdata-mindata));
[predicted_label, accuracy prob]= svmpredict(labels, scaleddata, m);
accuracy
save('challenge_model.mat','m');