% Written by Peter Hajas and Marton Aron Goda

function [startd, stopd] = select_nonsilent_longest(audio_data, fs, figures)

audio_data = audio_data(:)';

startd = 1;
stopd  = length(audio_data);

thr_null_min = round(25 * fs / 1000);	% Egszen 100-ig mehetnk

diff_audio = diff(audio_data);

i_d0 = find( diff_audio == 0 );

if( isempty(i_d0) )
	return;
end

di_d0 = diff( i_d0 );

i_di_d0_1 = find( ([0, di_d0] ~= 1) & ([di_d0, 0] == 1));
i_di_d0_2 = find( ([0, di_d0] == 1) & ([di_d0, 0] ~= 1));

i_to_delete = find( (i_d0(i_di_d0_2) - i_d0(i_di_d0_1)) > thr_null_min );

starts_of_ok = [1, i_d0(i_di_d0_2(i_to_delete))];
stops_of_ok  = [i_d0(i_di_d0_1(i_to_delete)), length(audio_data)];

[~, i] = max(stops_of_ok - starts_of_ok);

startd = starts_of_ok(i);
stopd  = stops_of_ok(i);

if(figures)
	figure(10)
	plot(audio_data)
	hold on;
	plot(startd, 0, 'r*')
	plot(stopd, 0, 'g*')
	hold off;
	pause
end

return