% Written by Pter Hajas and Mrton ron Goda

function [x_fft, fft_amp_mat] = get_seg_fft_amp_mat_v01(audio, fs, i_start, i_stop, len_fft)

	x_fft = linspace(0, fs/2, len_fft);
	fft_amp_mat = zeros(1, len_fft);
	
	if( isempty(i_start) || isempty(i_stop) )
		return;
	end
	
	if( i_start(1) > i_stop(1) )
		disp('error: get_seg_mean_fft');
		return;
% 		i_stop = i_stop(2 : end);
	end

	if( i_start(end) > i_stop(end) )
		disp('error: get_seg_mean_fft');
		return;
% 		i_start = i_start(1 : end-1);
	end
	
	if( length(i_start) ~= length(i_stop) )
		disp('error: get_seg_mean_fft');
		return;
	end
	
	l_segment = i_stop - i_start + 1;
	
	mean_len = trimmean(l_segment, 10);
	i_inlier = find( (l_segment < mean_len * 1.5) & (l_segment > mean_len * 0.5) );
	
	i_start = i_start(i_inlier);
	i_stop  = i_stop(i_inlier);
	
	l_segment = i_stop - i_start + 1;
	n_segment = length(i_start);
	
	fft_amp_mat = zeros(n_segment, len_fft);
	for i = 1 : n_segment
% 		i
        audio_segment = audio(i_start(i) : i_stop(i));
		audio_segment = audio_segment - mean(audio_segment);
		fft_audio = fft(audio_segment, len_fft * 2);
		fft_audio = abs(fft_audio(1 : len_fft));
		fft_amp_mat(i, :) = fft_audio ./ l_segment(i);
	end
	