% Written by Pter Hajas and Mrton ron Goda

function mean_fft = fft_amp_mat2fft_mean_v01(fft_amp_mat, to_normalize)
	
	[n_segment, len_fft] = size(fft_amp_mat);
	
	integral_of_fft = sum(fft_amp_mat, 2);
	mean_of_integral_of_fft = mean(integral_of_fft);
	
	j = 0;
	for i = 1 : n_segment
		if(to_normalize)
			integral = integral_of_fft(i);
		else
			integral = 1;
		end
		if( integral > mean_of_integral_of_fft / 100)
			j = j + 1;
			fft_amp_mat(j, :) = fft_amp_mat(i, :) / integral;
		end
	end
	if(j>0)
		fft_amp_mat = fft_amp_mat(1 : j, :);
		mean_fft = trimmean(fft_amp_mat, 10, 1);
	else
		mean_fft = zeros(1, len_fft);
	end