function [h, g, L] = myfilter(name)
%%
%% Define high-pass and low-pass filter coefficients of length (L)
%% ------------------------------------------------------------------------
%% Input: name  Character string; 'haar', 'd4', 'la8', 'la16'
%%
%% Output: h  Vector of high-pass filter coefficients
%%         g  Vector of low-pass filter coefficients
%%         L  Length of filter coefficients
%%
switch name
  case 'haar' 
    L = 2;
    h = [0.7071067811865475 -0.7071067811865475];
    g = [0.7071067811865475 0.7071067811865475];
  case 'd4' 
    L = 4;
    h = [-0.1294095225512603 -0.2241438680420134 0.8365163037378077 ...
	   -0.4829629131445341];
    g = [0.4829629131445341 0.8365163037378077 0.2241438680420134 ...
	  -0.1294095225512603];
  case 'la8' 
    L = 8;
    h = [0.03222310060407815 0.01260396726226383 -0.09921954357695636 ...
	  -0.29785779560560505 0.80373875180538600 -0.49761866763256290 ...
	  -0.02963552764596039 0.07576571478935668];
    g = [-0.07576571478935668 -0.02963552764596039 0.49761866763256290 ...
	   0.80373875180538600 0.29785779560560505 -0.09921954357695636 ...
	   -0.01260396726226383 0.03222310060407815];
  case 'la16' 
    L = 16;
    h = [0.0018899503329007 0.0003029205145516 -0.0149522583367926 ...
	  -0.0038087520140601 0.0491371796734768 0.0272190299168137 ...
	  -0.0519458381078751 -0.3644418948359564 0.7771857516997478 ...
	  -0.4813596512592012 -0.0612733590679088 0.1432942383510542 ...
	  0.0076074873252848 -0.0316950878103452 -0.0005421323316355 ...
	  0.0033824159513594];
    g = [-0.0033824159513594 -0.0005421323316355 0.0316950878103452 ...
	   0.0076074873252848 -0.1432942383510542 -0.0612733590679088 ...
	   0.4813596512592012 0.7771857516997478 0.3644418948359564 ...
	   -0.0519458381078751 -0.0272190299168137 0.0491371796734768 ...
	   0.0038087520140601 -0.0149522583367926 -0.0003029205145516 ...
	   0.0018899503329007];
  otherwise
    error('Invalid selection for myfilter');
end
