function [statsOut] = extractPeakStats(segs, PCG)

PCG = normalise_signal(PCG);

statsOut = [];

for s=1:4
    intervals = [];
    widths = [];
    amplitudes = [];
    peakCount = 0;
    segCount = 0;
    
    for i=1:size(segs,1)
        segCount = segCount+1;
        nextSeg = s+1;
        nextRow = i;
        if s==4
            nextSeg = 1;
            if i+1 > size(segs,1), break;end
            nextRow = i+1;
        end
        
        curChunk = PCG(segs(i,s):segs(nextRow,nextSeg)-1);
        if isempty(curChunk),continue;end
        
        [y,x,w,~] = findpeaks(curChunk,'MinPeakHeight', median(curChunk), 'MinPeakDistance', 0.05*length(curChunk));
        features = [x, y, w];
        if isempty(features),continue;end
        intervals = [intervals; diff(features(:,1))];
        widths = [widths; features(:,3)];
        amplitudes = [amplitudes; features(:,2)];
        peakCount = peakCount + numel(features(:,3));
    end
    tempStats = [trimmean(amplitudes,10), peakCount / segCount, trimmean(widths,10), trimmean(intervals,10)];
    statsOut = [statsOut;tempStats];
end

s1_s2 = statsOut(1,1) / statsOut(3,1);
s1_sys = statsOut(1,1) / statsOut(2,1);
s1_diast = statsOut(1,1) / statsOut(4,1);
sys_diast = statsOut(2,1) / statsOut(4,1);

statsOut = [statsOut;s1_s2,s1_sys,s1_diast,sys_diast];
statsOut = statsOut(:)';

end