function [ outputStats ] = extractFreqStats( A, PCG )
load('bpFilters2.mat');
% Frequency analysis
SampleRate = 1000;

for i=1:size(A,1)-1
    sysAmp(i) = trimmean(PCG(A(i,2):A(i,3)),20);
    diasAmp(i) = trimmean(PCG(A(i,4):A(i+1,1)),20);
    
    maxFreqIntS1  = calcDomFreq(PCG(A(i,1):A(i,2)), 2*length(PCG(A(i,1):A(i,2))), SampleRate);
    maxFreqIntSys  = calcDomFreq(PCG(A(i,2):A(i,3)), 2*length(PCG(A(i,2):A(i,3))), SampleRate);
    maxFreqIntS2 = calcDomFreq(PCG(A(i,3):A(i,4)), 2*length(PCG(A(i,3):A(i,4))), SampleRate);
    maxFreqIntDia = calcDomFreq(PCG(A(i,4):A(i+1,1)), 2*length(PCG(A(i,4):A(i+1,1))), SampleRate);   %#ok<*NASGU>
    
    maxAmp = max([maxFreqIntS1,maxFreqIntSys,maxFreqIntS2,maxFreqIntDia]);
    s1SysS2Q(i) =  maxAmp / obw(PCG(A(i,1):A(i,4)), SampleRate);
    bandPwrS1SysS2(i) = bandpower(PCG(A(i,1):A(i,4)));
    
    powerLowAll(i) = 0;
    powerMedAll(i) = 0;
    powerMedHighAll(i) = 0;
    powerHighAll(i) = 0;
    
    powerLowSys(i) = 0;
    powerMedSys(i) = 0;
    powerMedHighSys(i) = 0;
    powerHighSys(i) = 0;
    
    powerLowDias(i) = 0;
    powerMedDias(i) = 0;
    powerMedHighDias(i) = 0;
    powerHighDias(i) = 0;
    
    if (length(PCG(A(i,1):A(i,4))) > 12)
        lowAll = filtfilt(b1,a1,PCG(A(i,1):A(i,4)));
        powerLowAll(i) = (norm(lowAll)^2)/length(lowAll);
        medAll = filtfilt(b2,a2,PCG(A(i,1):A(i,4)));
        powerMedAll(i) = (norm(medAll)^2)/length(medAll);
        medhighAll = filtfilt(b3,a3,PCG(A(i,1):A(i,4)));
        powerMedHighAll(i) = (norm(medhighAll)^2)/length(medhighAll);
        highAll = filtfilt(b4,a4,PCG(A(i,1):A(i,4)));
        powerHighAll(i) = (norm(highAll)^2)/length(highAll);
    end
    
    if (length(PCG(A(i,2):A(i,3))) > 12)
        lowSys = filtfilt(b1,a1,PCG(A(i,2):A(i,3)));
        powerLowSys(i) = (norm(lowSys)^2)/length(lowSys);
        medSys = filtfilt(b2,a2,PCG(A(i,2):A(i,3)));
        powerMedSys(i) = (norm(medSys)^2)/length(medSys);
        medhighSys = filtfilt(b3,a3,PCG(A(i,2):A(i,3)));
        powerMedHighSys(i) = (norm(medhighSys)^2)/length(medhighSys);
        highSys = filtfilt(b4,a4,PCG(A(i,2):A(i,3)));
        powerHighSys(i) = (norm(highSys)^2)/length(highSys);
    end
    
    if (length(PCG(A(i,4):A(i+1,1))) > 12)
        lowDias = filtfilt(b1,a1,PCG(A(i,4):A(i+1,1)));
        powerLowDias(i) = (norm(lowDias)^2)/length(lowDias);
        medDias = filtfilt(b2,a2,PCG(A(i,4):A(i+1,1)));
        powerMedDias(i) = (norm(medDias)^2)/length(medDias);
        medhighDias = filtfilt(b3,a3,PCG(A(i,4):A(i+1,1)));
        powerMedHighDias(i) = (norm(medhighDias)^2)/length(medhighDias);
        highDias = filtfilt(b4,a4,PCG(A(i,4):A(i+1,1)));
        powerHighDias(i) = (norm(highDias)^2)/length(highDias);
    end
    
    pwrExpRange(i) = bandpower(PCG(A(i,1):A(i,4)),SampleRate,[15,200]);
end

trimMeanS1 = trimmean(A(:,2)-A(:,1),20); % trimmean value of S1 intervals
trimMeanSys = trimmean(A(:,3)-A(:,2),20); % trimmean value of Sys intervals
qFactS1SysS2 = trimmean(s1SysS2Q, 20); % trimmean value of Q-factors for S1,Sys,S2
pwrS1SysS2 = trimmean(bandPwrS1SysS2,20); % trimmean value of bandpower for S1, Sys, S2
mean12 = max(trimmean(sysAmp,20),trimmean(diasAmp,20));

powerLowAllAvg = trimmean(powerLowAll, 20);
powerMedAllAvg = trimmean(powerMedAll, 20);
powerMedHighAllAvg = trimmean(powerMedHighAll, 20);
powerHighAllAvg = trimmean(powerHighAll, 20);

ratioLowtoMedAll = powerLowAllAvg / powerMedAllAvg;
ratioMedtoHighAll = powerMedAllAvg / powerHighAllAvg;
ratioLowtoHighAll = powerLowAllAvg / powerHighAllAvg;
ratioLowtoMedHighAll = powerLowAllAvg / powerMedHighAllAvg;

powerLowSysAvg = trimmean(powerLowSys, 20);
powerMedSysAvg = trimmean(powerMedSys, 20);
powerMedHighSysAvg = trimmean(powerMedHighSys, 20);
powerHighSysAvg = trimmean(powerHighSys, 20);

ratioLowtoMedSys = powerLowSysAvg / powerMedSysAvg;
ratioMedtoHighSys = powerMedSysAvg / powerHighSysAvg;
ratioLowtoHighSys = powerLowSysAvg / powerHighSysAvg;
ratioLowtoMedHighSys = powerLowSysAvg / powerMedHighSysAvg;

powerLowDiasAvg = trimmean(powerLowDias, 20);
powerMedDiasAvg = trimmean(powerMedDias, 20);
powerMedHighDiasAvg = trimmean(powerMedHighDias, 20);
powerHighDiasAvg = trimmean(powerHighDias, 20);

ratioLowtoMedDias = powerLowDiasAvg / powerMedDiasAvg;
ratioMedtoHighDias = powerMedDiasAvg / powerHighDiasAvg;
ratioLowtoHighDias = powerLowDiasAvg / powerHighDiasAvg;
ratioLowtoMedHighDias = powerLowDiasAvg / powerMedHighDiasAvg;

powerExpRangeAvg = trimmean(pwrExpRange, 20);

outputStats = [powerLowAllAvg, powerMedAllAvg, powerMedHighAllAvg, powerHighAllAvg,...
    powerLowSysAvg, powerMedSysAvg, powerMedHighSysAvg, powerHighSysAvg,...
    powerLowDiasAvg, powerMedDiasAvg, powerMedHighDiasAvg, powerHighDiasAvg,...
    ratioLowtoMedAll, ratioMedtoHighAll, ratioLowtoHighAll, ratioLowtoMedHighAll,...
    ratioLowtoMedSys, ratioMedtoHighSys, ratioLowtoHighSys, ratioLowtoMedHighSys,...
    ratioLowtoMedDias, ratioMedtoHighDias, ratioLowtoHighDias, ratioLowtoMedHighDias,...
    trimMeanS1,trimMeanSys, qFactS1SysS2, pwrS1SysS2, mean12, powerExpRangeAvg];
end