function classifyResult = classifyFromHsIntervalscR0(features)
%
% This function gives the classification result for heart sound recording
% using the obtained features
%
%
% INPUTS:
% features: the obtained features
%
% OUTPUTS:
% classifyResult: classification result for the heart sound recording
% classifyResult = 1 for abnormal recording
%                = -1 for normal recording
%                = 0 for unsure recording (too noisy)
%
%
% Written by: Chengyu Liu, January 22 2016
%             chengyu.liu@emory.edu
%
% Last modified by:
%

%%  TCS 2016 - Developed by TCS Innovation Labs

load('SVM.mat');
% rehash;
predictor=svmclassify(SVM,features);

%% Calssificaiton
% we only provide the normal/abnormal classification, if you think the
% current recording is too noisy, you can set classifyResult=0. The score
% function will consider the classifyResult=0 situations.
thr  = 0.5; % classification threshold, thr>0.5 for abnormal recordings.
if predictor > thr
    classifyResult = 1;
else
    classifyResult = -1;
end
