function DataProcessed  = TCS_preprocessing(DataR)
%%  TCS 2016 - Developed by TCS Innovation Labs
springer_options    = default_Springer_HSMM_options;
Interval            = ceil((((springer_options.audio_Fs*60)/72)*96)/100);
Gain    = 10;
i       = 1;
warning('off','all');

        Time = round(length(DataR)/springer_options.audio_Fs);
        
%%%%%%%%%%%%%%%%%%data trim%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        DataRT = DataR;
        if(Time >= 6)
        DataRT = DataR(1*springer_options.audio_Fs+1:end-1*springer_options.audio_Fs);
        end

        if(Time < 6 && Time >= 4)
        DataRT = DataR(0.5*springer_options.audio_Fs+1:end-0.5*springer_options.audio_Fs);
        end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%Spike Equalizer%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        [Freq,BinCen] = hist(DataRT);
        Count = (Freq(1)+Freq(end));
        Condition = (Count<Time*Gain);

    while(Condition)

                for j=1:length(BinCen)-1
                Mean_X(j) = (BinCen(j)+BinCen(j+1))/2;
                end
                if(Freq(1)<Time*(Gain/2))
                IndLow = find(DataRT<Mean_X(1));
                DataRT(IndLow) = Mean_X(2);
                end
                if(Freq(end)<Time*(Gain/2))
                IndHigh = find(DataRT>Mean_X(9));
                DataRT(IndHigh) =  Mean_X(8);
                end
            [Freq,BinCen] = hist(DataRT);
            Count = (Freq(1)+Freq(10));
            Condition = (Count<Time*Gain);
     end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%Data normalization%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%% zscore and amplidute based%%%%%%%%%%%%

        DataRT  = zscore(DataRT);
        DataRTN = DataRT/max(abs(DataRT));
       
        DataRTabs  = zscore(abs(DataRT));
        DataRTNabs = DataRTabs/max(abs(DataRTabs));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%        

%%%%%%%%%%%%%%% Removal of no-signal bands%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Count1  = 1;
        Count3  = 1;
        Array   = [];
        TrimmerArray = [];

        ThetaI = find(DataRTNabs<=0);
        ThetaIDiff = diff(ThetaI);
        ThetaIDiff = [ThetaIDiff; 2];
         
        for Count2 = 2:length(ThetaIDiff)-1
             if(ThetaIDiff(Count2-1)==1 && ThetaIDiff(Count2)==1 && Count2==2)
                Array(Count1,1)= ThetaI(Count2);
            end
            if(ThetaIDiff(Count2-1)~=1 && ThetaIDiff(Count2)==1)
                Array(Count1,1)= ThetaI(Count2);
            end
            if(ThetaIDiff(Count2)==1 && ThetaIDiff(Count2+1)~=1)
                Array(Count1,2)= ThetaI(Count2);
                Count1 = Count1+1;
            end
        end
        
        if( ~(isempty(Array)))
            ArrayDiff = Array(:,2) - Array(:,1);
            for Count4 = 1:size(Array,1) 
                if(ArrayDiff(Count4)>Interval)
                    TrimmerArray(Count3,:) = Array(Count4,:);
                    Count3 = Count3+1;
                end
            end
        end
        if( ~(isempty(TrimmerArray)))
               
               CulledLength = sum(TrimmerArray(:,2)- TrimmerArray(:,1));
               
        else
            CulledLength =0;
        end 
        
        
       if(size(TrimmerArray,1)~=0)
            for Temp = 1:size(TrimmerArray,1)
                    if(Temp==1)
                        DataProcessed = DataRTN(1:TrimmerArray(Temp,1));
                    end
                    if(Temp==1&&Temp == size(TrimmerArray,1))
                        DataProcessed = [DataProcessed; DataRTN(TrimmerArray(Temp,2):length(DataRTN))];
                    end
                    if(Temp~=1&&Temp <= size(TrimmerArray,1))
                        DataProcessed = [DataProcessed; DataRTN(TrimmerArray(Temp-1,2):TrimmerArray(Temp,1))];
                    end
                    if(Temp~=1&&Temp == size(TrimmerArray,1))
                        DataProcessed = [DataProcessed; DataRTN(TrimmerArray(Temp,2):length(DataRTN))];
                    end
            end
       else
           DataProcessed = DataRTN;
       end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%Procedure information%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        SignalAttributes(i,1) = length(DataR);
        SignalAttributes(i,2) = Time;
        SignalAttributes(i,3) = length(DataRT);
        SignalAttributes(i,4) = size(TrimmerArray,1);
        SignalAttributes(i,5) = CulledLength ;
        SignalAttributes(i,6) = length(DataProcessed);
        SignalAttributes(i,7) = (SignalAttributes(i,5)/SignalAttributes(i,3))*100;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

       clearvars -except SignalAttributes springer_options Interval Gain DataProcessed
end       
      



