function [ParamVector] = A_FeatureExtraction(FeatureIndices,PCG,A)
%%  TCS 2016 - Developed by TCS Innovation Labs
springer_options    = default_Springer_HSMM_options;
features1 = [];
features2 = [];
features3 = [];

    % %% Feature calculation
    if(ismember(1,FeatureIndices))
        m_RR        = round(mean(diff(A(:,1))));             % mean value of RR intervals
        features1 = [features1 m_RR];
    end
    if(ismember(2,FeatureIndices))
        sd_RR       = round(std(diff(A(:,1))));              % standard deviation (SD) value of RR intervals
        features1 = [features1 sd_RR];
    end    
    if(ismember(3,FeatureIndices))
        mean_IntS1  = round(mean(A(:,2)-A(:,1)));            % mean value of S1 intervals
        features1 = [features1 mean_IntS1];
    end
    if(ismember(4,FeatureIndices))
        sd_IntS1    = round(std(A(:,2)-A(:,1)));             % SD value of S1 intervals
        features1 = [features1 sd_IntS1];
    end
    if(ismember(5,FeatureIndices))
        mean_IntS2  = round(mean(A(:,4)-A(:,3)));            % mean value of S2 intervals
        features1 = [features1 mean_IntS2];
    end
    if(ismember(6,FeatureIndices))
        sd_IntS2    = round(std(A(:,4)-A(:,3)));             % SD value of S2 intervals
        features1 = [features1 sd_IntS2];
    end
    if(ismember(7,FeatureIndices))
        mean_IntSys = round(mean(A(:,3)-A(:,2)));            % mean value of systole intervals
        features1 = [features1 mean_IntSys];
    end
    if(ismember(8,FeatureIndices))
        sd_IntSys   = round(std(A(:,3)-A(:,2)));             % SD value of systole intervals
        features1 = [features1 sd_IntSys];
    end
    if(ismember(9,FeatureIndices))
        mean_IntDia = round(mean(A(2:end,1)-A(1:end-1,4)));  % mean value of diastole intervals
        features1 = [features1 mean_IntDia];
    end
    if(ismember(10,FeatureIndices))
        sd_IntDia   = round(std(A(2:end,1)-A(1:end-1,4)));   % SD value of diastole intervals
        features1 = [features1 sd_IntDia];
    end
    
    
    if(any(ismember(11:20,FeatureIndices)))
        for i=1:size(A,1)-1
            R_SysRR(i)  = (A(i,3)-A(i,2))/(A(i+1,1)-A(i,1))*100;
            R_DiaRR(i)  = (A(i+1,1)-A(i,4))/(A(i+1,1)-A(i,1))*100;
            R_SysDia(i) = R_SysRR(i)/R_DiaRR(i)*100;

            P_S1(i)     = sum(abs(PCG(A(i,1):A(i,2))))/(A(i,2)-A(i,1));
            P_Sys(i)    = sum(abs(PCG(A(i,2):A(i,3))))/(A(i,3)-A(i,2));
            P_S2(i)     = sum(abs(PCG(A(i,3):A(i,4))))/(A(i,4)-A(i,3));
            P_Dia(i)    = sum(abs(PCG(A(i,4):A(i+1,1))))/(A(i+1,1)-A(i,4));
            if P_S1(i)>0
                P_SysS1(i) = P_Sys(i)/P_S1(i)*100;
            else
                P_SysS1(i) = 0;
            end
            if P_S2(i)>0
                P_DiaS2(i) = P_Dia(i)/P_S2(i)*100;
            else
                P_DiaS2(i) = 0;
            end
        end
    end


    if(ismember(11,FeatureIndices))
        m_Ratio_SysRR   = mean(R_SysRR);  % mean value of the interval ratios between systole and RR in each heart beat
        features1 = [features1 m_Ratio_SysRR];
    end
    if(ismember(12,FeatureIndices))
        sd_Ratio_SysRR  = std(R_SysRR);   % SD value of the interval ratios between systole and RR in each heart beat
        features1 = [features1 sd_Ratio_SysRR];
    end
    if(ismember(13,FeatureIndices))
        m_Ratio_DiaRR   = mean(R_DiaRR);  % mean value of the interval ratios between diastole and RR in each heart beat
        features1 = [features1 m_Ratio_DiaRR];
    end
    if(ismember(14,FeatureIndices))
        sd_Ratio_DiaRR  = std(R_DiaRR);   % SD value of the interval ratios between diastole and RR in each heart beat
        features1 = [features1 sd_Ratio_DiaRR];
    end
    if(ismember(15,FeatureIndices))
        m_Ratio_SysDia  = mean(R_SysDia); % mean value of the interval ratios between systole and diastole in each heart beat
        features1 = [features1 m_Ratio_SysDia];
    end
    if(ismember(16,FeatureIndices))
        sd_Ratio_SysDia = std(R_SysDia);  % SD value of the interval ratios between systole and diastole in each heart beat
        features1 = [features1 sd_Ratio_SysDia];
    end

if(any(ismember(17:20,FeatureIndices))) 
    
    indx_sys = find(P_SysS1>0 & P_SysS1<100);   % avoid the flat line signal 
    if length(indx_sys) > 1
        if(ismember(17,FeatureIndices))
            m_Amp_SysS1  = mean(P_SysS1(indx_sys)); % mean value of the mean absolute amplitude ratios between systole period and S1 period in each heart beat
            features1 = [features1 m_Amp_SysS1];
        end
        if(ismember(18,FeatureIndices))
            sd_Amp_SysS1 = std(P_SysS1(indx_sys));  % SD value of the mean absolute amplitude ratios between systole period and S1 period in each heart beat
            features1 = [features1 sd_Amp_SysS1];
        end
    else
        if(ismember(17,FeatureIndices))
            m_Amp_SysS1  = 0;
            features1 = [features1 m_Amp_SysS1];
        end
        if(ismember(18,FeatureIndices))
            sd_Amp_SysS1 = 0;
            features1 = [features1 sd_Amp_SysS1];
        end
    end
    
    indx_dia = find(P_DiaS2>0 & P_DiaS2<100);
    if length(indx_dia)>1
        if(ismember(19,FeatureIndices))
            m_Amp_DiaS2  = mean(P_DiaS2(indx_dia)); % mean value of the mean absolute amplitude ratios between diastole period and S2 period in each heart beat
            features1 = [features1 m_Amp_DiaS2];
        end
        if(ismember(20,FeatureIndices))
            sd_Amp_DiaS2 = std(P_DiaS2(indx_dia));  % SD value of the mean absolute amplitude ratios between diastole period and S2 period in each heart beat
            features1 = [features1 sd_Amp_DiaS2];
        end
    else
        if(ismember(19,FeatureIndices))
            m_Amp_DiaS2  = 0;
            features1 = [features1 m_Amp_DiaS2];
        end
        if(ismember(20,FeatureIndices))
            sd_Amp_DiaS2 = 0;
            features1 = [features1 sd_Amp_DiaS2];
        end
    end

end
    %% © TCS 2016 - Developed by TCS Innovation Labs​
    %%%%%%%%%%%%%%%%%%%%%%%%Ayan%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%Extraction of additional features%%%%%%%%%%%%%
    if(any(ismember(21:40,FeatureIndices)))
        for count=1:size(A,1)-1


                RR_wpt = wpdec(PCG(A(count,1):A(count+1,1)),3,'db3');
                S1_wpt = wpdec(PCG(A(count,1):A(count,2)),3,'db3');
                S2_wpt = wpdec(PCG(A(count,3):A(count,4)),3,'db3');
                Sys_wpt = wpdec(PCG(A(count,2):A(count,3)),3,'db3');
                Dia_wpt = wpdec(PCG(A(count,4):A(count+1,1)),3,'db3');

                %%%%finddimensions of tree data%%%%%%%%%%%%%%
                l=length(wpcoef(RR_wpt,[3 1]));
                m=length(wpcoef(S1_wpt,[3 1]));
                n=length(wpcoef(Sys_wpt,[3 1]));
                o=length(wpcoef(S2_wpt,[3 1]));
                p=length(wpcoef(Dia_wpt,[3 1]));

                RR_CFS = zeros(l,8);
                S1_CFS = zeros(m,8);
                Sys_CFS = zeros(n,8);
                S2_CFS = zeros(o,8);
                Dia_CFS = zeros(p,8);


                for temp = 0:7
                    RR_CFS(:,temp+1) = wpcoef(RR_wpt,[3 temp]);
                    S1_CFS(:,temp+1) = wpcoef(S1_wpt,[3 temp]);
                    Sys_CFS(:,temp+1) = wpcoef(Sys_wpt,[3 temp]);
                    S2_CFS(:,temp+1) = wpcoef(S2_wpt,[3 temp]);
                    Dia_CFS(:,temp+1) = wpcoef(Dia_wpt,[3 temp]);
                end

                %%%%%%%%%%%%%%%
                %Max_Coeff_Sys = find(Sys_CFS(:,1))
                %%%%%%%%%%%%%%%

                [RR_m,RR_n] = size(RR_CFS);
                [S1_m,S1_n] = size(S1_CFS);
                [Sys_m,Sys_n] = size(Sys_CFS);
                [S2_m,S2_n] = size(S2_CFS);
                [Dia_m,Dia_n] = size(Dia_CFS);

                RR_CFS = reshape(RR_CFS,[RR_m*RR_n,1]);
                S1_CFS = reshape(S1_CFS,[S1_m*S1_n,1]);
                Sys_CFS = reshape(Sys_CFS,[Sys_m*Sys_n,1]);
                S2_CFS = reshape(S2_CFS,[S2_m*S2_n,1]);
                Dia_CFS = reshape(Dia_CFS,[Dia_m*Dia_n,1]);


                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%considering only the
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%top half(TH) of the
                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%spectrum
                RR_CFS_TH = RR_CFS(1:round(length(RR_CFS)/2));
                S1_CFS_TH = S1_CFS(1:round(length(S1_CFS)/2));
                Sys_CFS_TH = Sys_CFS(1:round(length(Sys_CFS)/2));
                S2_CFS_TH = S2_CFS(1:round(length(S2_CFS)/2));
                Dia_CFS_TH = Dia_CFS(1:round(length(Dia_CFS)/2));

                S1_WPT_TH_En(count) = sum(S1_CFS_TH.^2);
                Sys_WPT_TH_En(count) = sum(Sys_CFS_TH.^2);
                S2_WPT_TH_En(count) = sum(S2_CFS_TH.^2);
                Dia_WPT_TH_En(count) = sum(Dia_CFS_TH.^2);
                RR_WPT_TH_En(count) = sum(RR_CFS_TH.^2);

                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


                S1_WPT_En(count) = sum(S1_CFS.^2);
                Sys_WPT_En(count) = sum(Sys_CFS.^2);
                S2_WPT_En(count) = sum(S2_CFS.^2);
                Dia_WPT_En(count) = sum(Dia_CFS.^2);
                RR_WPT_En(count) = sum(RR_CFS.^2);
        end      

                %%%%%%%%Ratio computation%%%%%%%%%%%%%%

                R_S1_RR = (S1_WPT_En./RR_WPT_En).*100;
                %R_S1_RR = FeatureValueModeration(R_S1_RR);
                R_Sys_RR = (Sys_WPT_En./RR_WPT_En).*100;
                %R_Sys_RR = FeatureValueModeration(R_Sys_RR);
                R_S2_RR = (S2_WPT_En./RR_WPT_En).*100;
                %R_S2_RR = FeatureValueModeration(R_S2_RR);
                R_Dia_RR = (Dia_WPT_En./RR_WPT_En).*100;
                %R_Dia_RR = FeatureValueModeration(R_Dia_RR);
                R_S1_S2 = (S1_WPT_En./S2_WPT_En).*100;
                %R_S1_S2 = FeatureValueModeration(R_S1_S2);
                R_Sys_Dia = (Sys_WPT_En./Dia_WPT_En).*100;
                %R_Sys_Dia = FeatureValueModeration(R_Sys_Dia);
                R_S1_Sys = (S1_WPT_En./Sys_WPT_En).*100;
                %R_S1_Sys = FeatureValueModeration(R_S1_Sys);
                R_S1_Dia = (S1_WPT_En./Dia_WPT_En).*100;
                %R_S1_Dia = FeatureValueModeration(R_S1_Dia);
                R_S2_Sys = (S2_WPT_En./Sys_WPT_En).*100;
                %R_S2_Sys = FeatureValueModeration(R_S2_Sys);
                R_S2_Dia = (S2_WPT_En./Dia_WPT_En).*100;
                %R_S2_Dia = FeatureValueModeration(R_S2_Dia);


                features2=[];

%                 R_S1_S2_TH = (S1_WPT_TH_En./S2_WPT_TH_En)*100;
    end
            %%%%%%%%%%% mean & std Dev. of ratio vals%%%%%%%%% 
            if(ismember(21,FeatureIndices))
                R_mean_S1_RR = mean(R_S1_RR);
                features2 = [features2 R_mean_S1_RR];
            end
            if(ismember(22,FeatureIndices))
                R_sd_S1_RR = std(R_S1_RR);
                features2 = [features2 R_sd_S1_RR];
            end
            if(ismember(23,FeatureIndices))
                R_mean_Sys_RR = mean(R_Sys_RR);
                features2 = [features2 R_mean_Sys_RR];
            end
            if(ismember(24,FeatureIndices))
                R_sd_Sys_RR = std(R_Sys_RR);
                features2 = [features2 R_sd_Sys_RR];
            end
            if(ismember(25,FeatureIndices))
                R_mean_S2_RR = mean(R_S2_RR);
                features2 = [features2 R_mean_S2_RR];
            end
            if(ismember(26,FeatureIndices))
                R_sd_S2_RR = std(R_S2_RR);
                features2 = [features2 R_sd_S2_RR];
            end
            
            if(ismember(27,FeatureIndices))
                R_mean_Dia_RR = mean(R_Dia_RR);
                features2 = [features2 R_mean_Dia_RR];
            end
            if(ismember(28,FeatureIndices))
                R_sd_Dia_RR = std(R_Dia_RR);
                features2 = [features2 R_sd_Dia_RR];
            end

            if(ismember(29,FeatureIndices))
                R_mean_S1_S2 = mean(R_S1_S2);
                features2 = [features2 R_mean_S1_S2];
            end
            if(ismember(30,FeatureIndices))
                R_sd_S1_S2 = std(R_S1_S2);
                features2 = [features2 R_sd_S1_S2];
            end

            if(ismember(31,FeatureIndices))
                R_mean_Sys_Dia = mean(R_Sys_Dia);
                features2 = [features2 R_mean_Sys_Dia];
            end
            if(ismember(32,FeatureIndices))
                R_sd_Sys_Dia = std(R_Sys_Dia);
                features2 = [features2 R_sd_Sys_Dia];
            end

            if(ismember(33,FeatureIndices))
                R_mean_S1_Sys = mean(R_S1_Sys);
                features2 = [features2 R_mean_S1_Sys];
            end
            if(ismember(34,FeatureIndices))
                R_sd_S1_Sys = std(R_S1_Sys);
                features2 = [features2 R_sd_S1_Sys];
            end
            
   
            if(ismember(35,FeatureIndices))
                R_mean_S1_Dia = mean(R_S1_Dia);
                features2 = [features2 R_mean_S1_Dia];
            end
            if(ismember(36,FeatureIndices))
                R_sd_S1_Dia = std(R_S1_Dia);
                features2 = [features2 R_sd_S1_Dia];
            end

            if(ismember(37,FeatureIndices))
                R_mean_S2_Sys = mean(R_S2_Sys);
                features2 = [features2 R_mean_S2_Sys];
            end
            if(ismember(38,FeatureIndices))
                R_sd_S2_Sys = std(R_S2_Sys);
                features2 = [features2 R_sd_S2_Sys];
            end

            if(ismember(39,FeatureIndices))
                R_mean_S2_Dia = mean(R_S2_Dia);
                features2 = [features2 R_mean_S2_Dia];
            end
            if(ismember(40,FeatureIndices))
                R_sd_S2_Dia = std(R_S2_Dia);
                features2 = [features2 R_sd_S2_Dia];
            end

%             R_mean_S1_S2_TH = mean(R_S1_S2_TH );
%             R_sd_S1_S2_TH = std(R_S1_S2_TH );

            
            data = PCG;

                    %%FFT Coeffs%%
                [Coeff,f] = FFT_Function(data,springer_options.audio_Fs);


                %%%%%%Features%%%%%%%%
                
                features3=[];
                %%%%Trimmed mean%%%
                if(ismember(41,FeatureIndices))
                    trimmed_mean = trimmean(Coeff,10); %1   
                    features3=[features3 trimmed_mean];
                end

                %%%skewness of the PCG FFT Coefficient%%%%%%
                if(ismember(42,FeatureIndices))
                    PCGskewness = skewness(Coeff); %2
                    features3=[features3 PCGskewness];
                end

                %%Compute 80% energy containing band%%%
                if(ismember(43,FeatureIndices))
                    Freq80Percent = Energy80percent(Coeff,f); %3
                    features3=[features3 Freq80Percent];
                end

                %%Kurtosis of frequency coefficients%%%
                if(ismember(44,FeatureIndices))
                    KurtosisFreqDom = kurtosis(Coeff); %4 
                    features3=[features3 KurtosisFreqDom];
                end
                
                %%Kurtosis of time series data%%%
                if(ismember(45,FeatureIndices))
                    KurtosisTimeDom = kurtosis(data); %5
                    features3=[features3 KurtosisTimeDom];
                end
                if(ismember(46,FeatureIndices))
                % Hjorth parameters%
                [~, ~, COMPLEXITY] = hjorth(data); %6
                features3=[features3 COMPLEXITY];
                end
                %%Total Power%%
                if(ismember(47,FeatureIndices))
                    TotPower = (norm(data,2)^2)/length(data); %7
                    features3=[features3 TotPower];
                end

                %Total Harmonic Distortion (THD)
                if(ismember(48,FeatureIndices))
                    TDH = thd(data); %8
                    features3=[features3 TDH];
                end

                %Zero Crossing Rate (ZCR)
                if(ismember(49,FeatureIndices))
                    vect1 = data(1:end-1);
                    vect2 = data(2:end);
                    vect = vect1.*vect2;
                    VectInd = find(vect<0);
                    ZCR = length(VectInd)/(length(data)-1); %9
                    features3=[features3 ZCR];
                end

                FrameSize = 1000;
                DataTrimmed = data(1:floor(length(data)/FrameSize)*FrameSize);
                %%Short time energy
                if(ismember(50,FeatureIndices))
                 
                    
                    for Count = 1:floor(length(data)/FrameSize)
                        Er(Count) = sum(DataTrimmed(FrameSize*(Count -1)+1:FrameSize*Count).^2)/FrameSize;
                    end
                    Er = mean(Er); %10
                    features3=[features3 Er];
                end

                %%Spectral Centriod
                if(ismember(51,FeatureIndices))
                    for Count = 1:floor(length(data)/FrameSize)
                        clippedData = DataTrimmed(FrameSize*(Count-1)+1:FrameSize*Count);
                        [Coeff_CD,f_CD] = FFT_Function(clippedData,1000);
                        Cr(Count) = sum(Coeff_CD.*f_CD')/sum(abs(Coeff_CD));
                    end
                    Cr = mean(Cr); %11
                    features3=[features3 Cr];
                end

                %%Spectral roll off
                if(ismember(52,FeatureIndices))
                    for Count = 1:floor(length(data)/FrameSize)
                        clippedData = DataTrimmed(FrameSize*(Count-1)+1:FrameSize*Count);
                        [Coeff_CD,f_CD] = FFT_Function(clippedData,1000);
                        Energy85P = 0.85*sum(abs(Coeff_CD));
                        CumSumCoeff = cumsum(Coeff_CD);
                        RrIndex = find(CumSumCoeff>Energy85P);
                        RrInd(Count) = min(RrIndex);
                    end
                    Rr = mean(RrInd); %12
                    features3=[features3 Rr];
                end

                %%Spectral flux
                if(ismember(53,FeatureIndices))
                    for Count = 1:floor(length(data)/FrameSize)-1
                        clippedData = DataTrimmed(FrameSize*(Count-1)+1:FrameSize*Count);
                        clippedDataNext = DataTrimmed(FrameSize*(Count)+1:FrameSize*(Count+1));
                        [Coeff_CD,f_CD] = FFT_Function(clippedData,1000);
                        [Coeff_CDNext,f_CDNext] = FFT_Function(clippedDataNext,1000);
                        Fr(Count) = sum((Coeff_CDNext - Coeff_CD).^2);
                    end
                    Fr = mean(Fr); %13
                    features3=[features3 Fr];
                end

                if(ismember(54,FeatureIndices))
                    Noise = snr(data,springer_options.audio_Fs);   %14 
                    features3=[features3 Noise];
                end
            
%             fprintf('\nFeature3 size=%d',size(features3,2));
              ParamVector = [features1 features2 features3];
end    



