function [file,label] = num2heart(num)

% Accepts a number between 1 and 3125, inclusive, and returns
% a string corresponding to the respective audio file.

dir1 = '../training/';

if num < 1 || num > 3126
    display('Number out of range!');
    file = [];
    return
end

if num >= 1 && num <= 409
    dir2 = 'training-a/';
    num = num;
elseif num >= 410 && num <= 899
    dir2 = 'training-b/';
    num = num - 409;
elseif num >= 900 && num <= 929
    dir2 = 'training-c/';
    num = num - 899;
elseif num >= 930 && num <= 984
    dir2 = 'training-d/';
    num = num - 929;
elseif num >= 985 && num <= 3125
    dir2 = 'training-e/';
    num = num - 984;
elseif num == 3126
    dir2 = 'training-c/';
    num = 31;
end

fid = fopen([dir1,dir2,'RECORDS']);
line = textscan(fid, '%s', 1, 'delimiter', '\n', 'headerlines', num-1);
fclose(fid);

label = csvread([dir1 dir2 'REFERENCE.csv'],num-1,1,[num-1,1,num-1,1]);

file = strcat(dir1,dir2,line{1});
file = file{1};

end