function classifyResult = challenge(recordName)
%
% Sample entry for the 2016 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     1 = abnormal recording
%                    -1 = normal recording
%                     0 = unsure (too noisy)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2016/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu, Fubruary 21 2016
%             chengyu.liu@emory.edu
%
% Last modified by: Brad Whitaker, July 18 2016
%                   b.whitaker@gatech.edu
%

%% Setup Environment
addpath('altmin');
addpath('classify');
addpath('data');
addpath('libsvm');
addpath('segmentation');

%% Read File
[y,Fs] = audioread([recordName '.wav']);

% Special case for long audio files (30 seconds).
% if length(y) > 60000
%     y = y(1:60000);
% end

%% Segment the Audio File and Calculate FFTs of each cycle/subcycle
FFTs = preprocessAudio(y,Fs);

%% Classify the processed audio file
classifyResult = classifyProcessedAudio(FFTs);

end