%%
clear
set(groot, 'defaultAxesFontSize',18,'defaultTextFontSize',18)
set(groot, 'defaultAxesTickLabelInterpreter','latex'); 
set(groot, 'defaultLegendInterpreter','latex');
set(0,'defaulttextinterpreter','latex')

load('matrix_results_all_datasets_dinesh_1000Hz.mat')
target = matrix_results_all_datasets_dinesh_1000Hz(:,1);
inputdata = matrix_results_all_datasets_dinesh_1000Hz(:,[2:end]);

% inputdata = scalestd(inputdata);

[correlacao_features,indices] = corr_features(inputdata,0.85);

indices = any(~isnan(correlacao_features), 2);
inputdata(:,~indices)=[];


feat = {'meanIntervalsystole', 'meanIntervaldiastole', 'stdIntervalsystole', 'stdIntervaldiastole',...
    'varIntervalsystole', 'varIntervaldiastole', 'medianIntervalsystole', 'medianIntervaldiastole',...
    'kurtosisIntervalsystole','kurtosisIntervaldiastole','skewnessIntervalsystole','skewnessIntervaldiastole',...
    'MDuration','MLoudness','MZeroCrossingRate','MTransTimeRatio','MEnergy Peak1','MEnergy_Peak2','Mfrequency_Peak1',...
    'Mfrequency_Peak2','Mspec_Power','Mpwband1','Mpwband2','Mpwband3','Mpwband4','Mfeq_Peak1_Est','Mfeq_Peak2_Est',...
    'Mspec_centroid','Mspec_Flux','Mspec_skew','Mspec_kurt','Mspec_slope','Mspec_rollfreq','Mskewness', 'Mkurtosis',...
    'SDuration','SLoudness','SZeroCrossingRate','STransTimeRatio','SEnergy Peak1','SEnergy_Peak2','Sfrequency_Peak1',...
    'Sfrequency_Peak2','Sspec_Power','Spwband1','Spwband2','Spwband3','Spwband4','Sfeq_Peak1_Est','Sfeq_Peak2_Est',...
    'Sspec_centroid','Sspec_Flux','Sspec_skew','Sspec_kurt','Sspec_slope','Sspec_rollfreq','Sskewness', 'Skurtosis'}';

feat(~indices) = [];

kw_sorted = kruskalwalli(inputdata,target,feat)

target_auc = [];
for jj = 1:size(target,1) 
    if target(jj)==1
        target_auc = [target; 1];
    elseif target(jj) == 0
        target_auc = [target_auc; 2];
    end
end

AUC_sorted = area_under_the_curve(inputdata,target_auc,feat)

data_input.X = inputdata;
data_input.y = target;
scree_sorted = scree(data_input,feat);




[ACC] = NeuralNetworkClassifier(inputdata, target)


[training_error,testing_error,training_data,testing_data,model,dfce,F1,C,sensibilidade,especificidade,precisao,fallout,AUC] = bayes(data_input,70)

% data_input.X = scalestd(data_input.X);
  

target = [];
for jj = 1:size(data_input.Y,1) 
    if data_input.Y(jj)==1
        target = [target; 1];
    elseif data.y(jj) == 0
        target = [target; 2];
    end
end

data_input.Y = target;

model = pca(data_input.X',10);
data.num_data = size(data_input.X',2);
out_data.X = linproj(data_input.X',model);
out_data.y = data_input.Y';
data.X = out_data.X';


figure()
ppatterns(out_data)
xlabel(' 1(st) Dimension')
ylabel(' 2(nd) Dimension')
title('Data features reduction by PCA (2 dimensions)')
legend('Match','Non-Match')






%%

tree = fitctree(cell2mat(matrix_results_all_datasets(:,3:end)),target, '', '');
% tree1 = prune(tree,'Level',20);
output = predict(tree,cell2mat(matrix_results_validation(:,3:end)));


% matrix_test = [target_bin cell2mat(matrix_results_all_datasets(:,3:end))];
% save('matrix_test.mat', 'matrix_test')

view(tree.Trained{1},'Mode','graph')



%%


abnormal = strcmp('Abnormal',target);
normal = strcmp('Normal',target);
abnormal_output = strcmp('Abnormal',output);
normal_output = strcmp('Normal',output);
Aa = numel(find(abnormal&abnormal_output));
Na = numel(find(abnormal&abnormal_output));
Nn = numel(find(normal&normal_output));
An = numel(find(normal&abnormal_output));
Aq = 0;
Nq = 0;

%     if size(matrix_results,2)==4
%         noise = strcmp('Noise',matrix_results(:,4));
%         Aq = numel(find(normal&noise));
%         Nq = numel(find(abnormal&noise));
%     end

Se = (Aa+0.5*Aq)/(Aa+An)*100;
Sp = (Nn+0.5*Nq)/(Na+Nn)*100;

%     performance_results(ii,1) = foldername(ii); 
%     performance_results(ii,2) = {round(Se*100)/100};
%     performance_results(ii,3) = {round(Sp*100)/100};
    
%     save('performance_results_with_noise.mat','performance_results')
