function [d,rms,tt_ratio,zeroscross]=time_features(x,fs)


% Teager-Kaiser energy operator
% [~,ex] = energyop(x); 
% teo = sum(ex);
% 
% % Katz fractal dimension
% kfd = Katz_FD(x);
% 
% % entropy
% ent = Entropy(x);

% loudness
rms = abs(sqrt(sum(x.^2)/length(x)));

% duration
d = 1000*(1/fs)*length(x); %in ms

%Transient times 
[~,ind] = max(x.^2);
rising_time = 1000*(1/fs)*length(x(1:ind));
releasing_time = 1000*(1/fs)*length(x(ind:length(x)));

tt_ratio = rising_time/releasing_time;

%zerocrossing rate
zeroscross = sum(abs(sign(x(1:end-1))-sign(x(2:end))))/length(x);