function [psdest,epk1,epk2,fpeak1,fpeak2,psdpower,pwbd1,pwbd2,pwbd3,pwbd4,...
          peakFreqEst,specCentroid,spFlux,spSkew,spKurt,spSlope,spRfreq,f...
          ,pxx] = frequency_features(x,fs)

%PSD estimation with Eigenvalue

% factor = 2^nextpow2(8000/15.625)
[pxx,~] = peig(x,15,512,fs);
%[pxx,fb]=pburg(x,10,512,fs);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%PSD estimation With Fourier Transform
sp_fft = fft(x.*hanning(length(x)),512);
pxxff = sp_fft.*conj(sp_fft)/512; %Power Spectrum by Fourier Transform

f = (fs)*(0:256)/512;
psdest = 10*log10(pxxff(1:257));
psd_eig = 10*log10(pxx);

spFlux = sum(abs(diff(psd_eig)));
% figure(2)

% subplot(211)
% % % scrsz = get(0,'ScreenSize');
% % % h_fig=figure('Position',[scrsz(4)/1.45 scrsz(4)/2.5 scrsz(3)/2.1 scrsz(4)/2])

% plot(f,psdest,f,psd_eig,'r')    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%frequency peaks
%rmax:power at peak frequency
%tx: peak frequency indices

% figure()
% plot(psd_eig)
[~,tx] = firstPeak(psd_eig);      
% hold on; plot(f(tx),rmax,'go'); hold off;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Conditions to avoid segments who don't have I & II peak frequency
%Emercially assigned by second lowest frequency
if isempty(tx)
    tx = 2*ones(1,2);
elseif length(tx)==1
    tx(2) = tx;    
end

fpeak1 = f(tx(1));
fpeak2 = f(tx(2));

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Integrated Band Energy
 
epk1 = 10*log10(sum(abs(pxx(1:tx(1)))'.*f(1:tx(1)))); %Energy_peak1
epk2 = 10*log10(sum(abs(pxx(tx(1):tx(2)))'.*f(tx(1):tx(2)))); %Energy_peak2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fourier Energy
psdpower = 10*log10(sum(abs(psd_eig'.*f)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Energy for 4 frequency band
pwbd1 = 10*log10(sum(abs(pxx(1:32))'.*f(1:32)));
pwbd2 = 10*log10(sum(abs(pxx(33:64))'.*f(33:64)));
pwbd3 = 10*log10(sum(abs(pxx(65:96))'.*f(65:96)));
pwbd4 = 10*log10(sum(abs(pxx(97:128))'.*f(97:128)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Another method for estimation of peak frequencies
%roots of ploynomial
[mfi, ~] = arburg(x,10);
r = roots(mfi);
ang = angle(r);
dom_freq = (fs/(2*length(x))).*ang(ang>0);%phase of conjugate are eliminated
peakFreqEst = dom_freq(1:2); %First dominant frequency

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Spectral Centroid
[B,f1,t] = specgram(x,64,fs);
B = abs(B);

% cenA = zeros (1, length(t));
% for jj = 1:length(t)
%     cenA(jj) = sum(B(:,jj).*f1)/sum(B(:,jj));
% end

f1_matrix = repmat(f1,[1 length(t)]);
cenA = sum(B.*f1_matrix)./sum(B);

specCentroid = sum(cenA);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Spectral Skewness, for symmetry of a distribution  
spSkew = skewness(psd_eig);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Spectral Kurtosis, measure of flatness of the power spectrum
spKurt = kurtosis(psd_eig);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%slope = the spectral slope reprsent the amount of decreasing of the
%spectral amplitude
p = polyfit(f',psd_eig,1);
spSlope = p(1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Spectral Roll-off
% powerSq = 10*log10(pxx.^2);
psd_95 = 0.9*sum(pxx.^2);
psd_cumulatative = cumsum(pxx.^2);
iPSD = find(psd_cumulatative<psd_95);
if ~isempty(iPSD)
  spRfreq = f(iPSD(end));
else
  spRfreq = 0;
end
