function [features] = extract_features(assigned_states, originalPCG, fs)


% PCG = originalPCG/sqrt(sum(abs(originalPCG .^2)) / length(originalPCG));
% normPCG = norm(originalPCG);
% if normPCG > 0,  % Or some other threshold, like EPS
%   PCG = (originalPCG-mean(originalPCG))/normPCG;
% else
%   PCG = originalPCG-mean(originalPCG);  % Do nothing since it's basically 0
% end

% PCG = (originalPCG-min(originalPCG))./(max(originalPCG)-min(originalPCG));

PCG = originalPCG;

time = linspace(0,(length(PCG))/fs,length(PCG));
% figure()
% plot(time, originalPCG,'b'), hold on
% plot(time, PCG,'r'), hold off

s1Segments = zeros(size(assigned_states));
s1Segments(assigned_states==1) = 1;
% systole = zeros(size(assigned_states));
% systole(assigned_states==2) = 1;
s2Segments = zeros(size(assigned_states));
s2Segments(assigned_states==3) = 1;
% diastole = zeros(size(assigned_states));
% diastole(assigned_states==2) = 1;

% Finding boundries index samples
[start_s1_index,end_s1_index] = boundariesDetection(s1Segments);
[start_s2_index,end_s2_index] = boundariesDetection(s2Segments);
% [start_systole_index,end_systole_index] = boundariesDetection(systole);
% [start_diastole_index,end_diastole_index] = boundariesDetection(diastole);

% start_s1_time = time(start_s1_index);
% end_s1_time = time(end_s1_index);
% start_s2_time = time(start_s2_index);
% end_s2_time = time(end_s2_index);

if start_s1_index(1)<start_s2_index(1) && start_s1_index(end)>start_s2_index(end)
    indexinterval_systole = [end_s1_index(1:end-1), start_s2_index];
    indexinterval_diastole = [end_s2_index, start_s1_index(2:end)];
    indexinterval_startS1_endS2 = [start_s1_index(1:end-1), end_s2_index];
    
elseif start_s1_index(1)<start_s2_index(1) && start_s1_index(end)<start_s2_index(end)
    indexinterval_systole = [end_s1_index, start_s2_index];
    indexinterval_diastole = [end_s2_index(1:end-1), start_s1_index(2:end)];
    indexinterval_startS1_endS2 = [start_s1_index, end_s2_index];
  
elseif start_s1_index(1)>start_s2_index(1) && start_s1_index(end)<start_s2_index(end)
    indexinterval_systole = [end_s1_index, start_s2_index(2:end)];
    indexinterval_diastole = [end_s2_index(1:end-1), start_s1_index];
    indexinterval_startS1_endS2 = [start_s1_index, end_s2_index(2:end)];
    
elseif start_s1_index(1)>start_s2_index(1) && start_s1_index(end)>start_s2_index(end)
    indexinterval_systole = [end_s1_index(1:end-1), start_s2_index(2:end)];
    indexinterval_diastole = [end_s2_index, start_s1_index];
    indexinterval_startS1_endS2 = [start_s1_index(1:end-1), end_s2_index(2:end)];
end

intervalsSystole = (indexinterval_systole(:,2)-indexinterval_systole(:,1));
intervalsDiastole = (indexinterval_diastole(:,2)-indexinterval_diastole(:,1));
meanIntervalsystole = mean(intervalsSystole)/fs;
meanIntervaldiastole = mean(intervalsDiastole)/fs;
stdIntervalsystole = std(intervalsSystole)/fs;
stdIntervaldiastole = std(intervalsDiastole)/fs;
varIntervalsystole = var(intervalsSystole)/fs;
varIntervaldiastole = var(intervalsDiastole)/fs;
medianIntervalsystole = median(intervalsSystole)/fs;
medianIntervaldiastole = median(intervalsDiastole)/fs;
kurtosisIntervalsystole = kurtosis(intervalsSystole)/fs;
kurtosisIntervaldiastole = kurtosis(intervalsDiastole)/fs;
skewnessIntervalsystole = skewness(intervalsSystole)/fs;
skewnessIntervaldiastole = skewness(intervalsDiastole)/fs;

featuresTime = [meanIntervalsystole, meanIntervaldiastole, stdIntervalsystole,...
    stdIntervaldiastole, varIntervalsystole, varIntervaldiastole, ...
    medianIntervalsystole, medianIntervaldiastole, kurtosisIntervalsystole, ...
    kurtosisIntervaldiastole, skewnessIntervalsystole, skewnessIntervaldiastole];

featureMatfin = [];
% index = min([length(start_s1_time) length(start_s2_time)]);
 
% figure()
% plot(time,PCG)
% hold on

% indexinterval_heart_cycle = [start_s1_index(1:end-1) start_s1_index(2:end)];

for ii = 1:length(indexinterval_startS1_endS2) 
    
    segmentPCG = PCG(indexinterval_startS1_endS2(ii,1):indexinterval_startS1_endS2(ii,2));
   
%     plot(time(indexinterval_systole(ii,1):indexinterval_systole(ii,2)),segmentPCG,'r') 
    if any(segmentPCG)==0 || numel(unique(segmentPCG))==1
        continue;
    else
        featureMat = FeatureExtractor(segmentPCG,fs);   
    end
    
    featureMatfin = [featureMatfin; featureMat'];
end

features = [featuresTime, mean(featureMatfin), std(featureMatfin)];

end


   

