function classifyResult = challenge(recordName)
%
% Sample entry for the 2016 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     1 = abnormal recording
%                     0 = normal recording
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2016/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu, Fubruary 21 2016
%             chengyu.liu@emory.edu
%
% Last modified by: Chengyu Liu, April 3 2016
%             Note: using 'audioread' to replace the 'wavread' function to load the .wav data.
%
%

%% Load the trained parameter matrices for Springer's HSMM model.
% The parameters were trained using 409 heart sounds from MIT heart
% sound database, i.e., recordings a0001-a0409.
load('Springer_B_matrix.mat');
load('Springer_pi_vector.mat');
load('Springer_total_obs_distribution.mat');

%% Load data and resample data
springer_options   = default_Springer_HSMM_options;

[PCG, fs]          = audioread([recordName '.wav']);  % load data
PCG_resampled      = resample(PCG,springer_options.audio_Fs,fs); % resample to springer_options.audio_Fs (1000 Hz)

%% Running runSpringerSegmentationAlgorithm.m to obtain the assigned_states
[assigned_states] = runSpringerSegmentationAlgorithm(PCG_resampled, springer_options.audio_Fs, Springer_B_matrix, Springer_pi_vector, Springer_total_obs_distribution, false); % obtain the locations for S1, systole, s2 and diastole

%% Running extractFeaturesFromHsIntervals.m to obtain the features for normal/abnormal heart sound classificaiton
% features = extract_features(assigned_states, PCG_resampled, springer_options.audio_Fs);

Features4KMEANS=FeatureDineshExtractor(PCG,fs, assigned_states);
load('MultiplexParam');
PCA_vecs=MultiplexParam.PCAvecs;
PCA_vecs=PCA_vecs(:,1:MultiplexParam.numPCAcomps);
Obs_cent=Features4KMEANS'-MultiplexParam.mean_feats;


Clusters=MultiplexParam.Ks;
Kmeans_entry=Obs_cent*PCA_vecs;
Kmeans_entry=repmat(Kmeans_entry,size(Clusters,1),1);
dists=(Kmeans_entry-Clusters).^2;
dists=sum(dists,2);
[~,Clusteri]=min(dists);

if Clusteri==1
    load('Knetwork1.mat')
    Knetwork=Knetwork1;
elseif Clusteri==2
    load('Knetwork2.mat')
    Knetwork=Knetwork2;
elseif Clusteri==3
    load('Knetwork3.mat')
    Knetwork=Knetwork3;
elseif Clusteri==4
    load('Knetwork4.mat')
    Knetwork=Knetwork4;
elseif Clusteri==5
    load('Knetwork5.mat')
    Knetwork=Knetwork5;
end


Features4Classifier=FeatureSpecImageExtractor(PCG,fs, assigned_states);

A=sim(Knetwork.net,Features4Classifier);
if A>Knetwork.th
    classifyResult=1;
else
    classifyResult=-1;
end

%% Running classifyFromHsIntervals.m to obtain the final classification result for the current recording

% features = (features-mean(features))/std(features);
% features([9,10,11,12]) = [];
% features(~[3, 5, 11, 22, 23, 24, 30, 35, 41, 46, 53, 55, 56, 57]) = [];
% load classifier_model
% % dfce = sim(classifier_model,norm_features);
% % classifyResult = dfce>0.3;
% classifyResult = predict(classifier_model,features);
%     
% if classifyResult==0
%     classifyResult = -1;
% end

