function Classifier_entry=FeatureSpecImageExtractor(HS,fs, assigned_states)

time = linspace(1/fs,(length(HS))/fs,length(HS));

assigned_states=ConvertAssignedStatesLenght(HS,assigned_states);
[start_s1, end_s1, start_s2, end_s2]=ConvertAssignedStatesForm(HS,assigned_states);

mean_dur_HC=mean(start_s1(2:end)-start_s1(1:end-1))/fs;

HS=HS-mean(HS);
min_lenght_p=100000;
P_mean=zeros(min_lenght_p,1);
cont=0;
for j =1:numel(start_s1)-1
    HC=HS(start_s1(j):start_s1(j+1));
    HC_d=HC-mean(HC);
    if abs(sqrt(sum(HC_d.^2)/length(HC_d)))<1e-10
        continue;
    end

    [y,f,t,p]=spectrogram(HC,64,32,[],fs);
    p_log=10*log10(abs(p)+eps);
    vec=reshape(p_log,numel(p_log),1);

    if numel(p_log)<min_lenght_p
        min_lenght_p=numel(p_log);
    elseif numel(p_log)>min_lenght_p
        vec=vec(1:min_lenght_p);
    end

    cont=cont+1;
    P_mean=P_mean(1:min_lenght_p,:);
    P_mean(:,cont)=vec;


end

vP_m=mean(P_mean,2);
       
try
num_fs=numel(f);
catch
    para=1;
end
num_els=numel(vP_m);
num_ts=num_els/num_fs;
M_P=reshape(vP_m,num_fs,num_ts);

t_min=t(1:num_ts);

t_int=linspace(t_min(1),t_min(end),30);
M_P_int=zeros(num_fs,numel(t_int));
for aa=1:num_fs
    M_P_int(aa,:)=interp1(t_min,M_P(aa,:),t_int);
end

M_P_final=M_P_int(f<500,:);
num_PCs=2;
M_4PCA=M_P_final;
[COEFF, SCORE, LATENT] = pca(M_4PCA);%,'Centered',false);
informatio=sum(LATENT(1:num_PCs))/sum(LATENT);
M_PCA=SCORE(:,1:num_PCs);
M_Vecs=COEFF(:,1:num_PCs);
Approx=M_PCA*M_Vecs';

Classifier_entry=reshape(M_PCA,numel(M_PCA),1);


