function featureMat = FeatureExtractor(OrgSound,fs)


% Features = struct('Time_domain',{{'Duration','Loudness','ZeroCrossingRate','TransTimeRatio','TKEO','Katz_Fractal_Dimension','Entropy'}},...
%                   'Frequency_domain',{{'Energy Peak1','Energy_Peak2','frequency_Peak1','frequency_Peak2','spec_Power'...
%                   'pwband1','pwband2','pwband3','pwband4','feq_Peak1_Est','feq_Peak2_Est','spec_centroid',...
%                   'spec_Flux','spec_skew','spec_kurt','spec_slope','spec_rollfreq'}},...
%                   'Statistical',{{'skewness', 'kurtosis'}});


fe=[];
    
[d,rms,tt_ratio,zeroscross] = time_features(OrgSound,fs);
[psdest,epk1,epk2,fpeak1,fpeak2,psdpower,pw1,pw2,pw3,pw4,peakFreqEst,...
    specCentroid,spFlux,spSkew,spKurt,spSlope,spRfreq] = frequency_features(OrgSound,fs);
 
%##########################################################################
%Time domain features
%##########################################################################
   
fe(1,:) = d; %duration;
fe(2,:) = rms; %loudness;
fe(3,:) = zeroscross; %zerocrossrate;
fe(4,:) = tt_ratio; %tranTimeRatio; 
% fe(5,:) = teo; % Tager-Kaiser energy operator
% fe(6,:) = kfd; % Katz fractal dimension
% fe(7,:) = segment_entropy; % entropy

%##########################################################################
%Frequency domain features
%##########################################################################
      
fe(5,:) = epk1; %EneryPeak1;
EneryPeak2 = epk2;
fe(6,:) = EneryPeak2;
fe(7,:) = fpeak1; %frequency_peak1;
fe(8,:) = fpeak2; %frequency_peak2;
fe(9,:) = psdpower; %segPower;
fe(10,:) = pw1; %pwband1;
fe(11,:) = pw2; %pwband2;
fe(12,:) = pw3; %pwband3;
fe(13,:) = pw4; %pwband4;
fe(14,:) = peakFreqEst(1); %peakFreqEstimated1;
fe(15,:) = peakFreqEst(2); %peakFreqEstimated2;
fe(16,:) = specCentroid; %spectralCentroid;
fe(17,:) = spFlux;%spectralFlux;
fe(18,:) = spSkew; % spectralSkew;
fe(19,:) = spKurt; %spectralkurt;
fe(20,:) = spSlope; %spectralSlope;
fe(21,:) = spRfreq; %spectralRollFreq;

%##########################################################################
%Statistical features
%##########################################################################

fe(22,:) = skewness(OrgSound); %norm_skew;
fe(23,:) = kurtosis(OrgSound); % norm_kurtosis;
 
%PRINT
% pp = 1;
% while 1
%     
%  if pp <=7
%           %disp('### Feature : Time Domain')
%           fprintf ('%s = %0.4f \n',Features.Time_domain{pp},fe(pp,:))
%  elseif pp>7 &&  pp<=24
%           %disp('###  Feature : Frequency Domain')
%           fprintf ('%s = %0.4f \n',Features.Frequency_domain{pp-7},fe(pp,:))
%  elseif pp>24 && pp<=26 
%           fprintf ('%s = %0.4f \n',Features.Statistical{pp-24},fe(pp,:))
%  end    
%   
%  if pp>26
%      break;
%  else
%      pp = pp+1;
%  end
% end
featureMat = fe;

