function varargout = detcoef1(coefs,longs,levels,dummy) %#ok<INUSD>

nmax = length(longs)-2;
cellFLAG = false;
if nargin>2
    if isnumeric(levels)
        if (any(levels < 1)) || (any(levels > nmax) ) || ...
            any(levels ~= fix(levels))
            error(message('Wavelet:FunctionArgVal:Invalid_LevVal'));
        end
        cellFLAG = (nargin>3);
    else
        cellFLAG = true;
        levels = 1:nmax;
    end   
else
    levels = nmax;
end

first = cumsum(longs)+1;
first = first(end-2:-1:1);
longs = longs(end-1:-1:2);
last  = first+longs-1;
nblev = length(levels);
tmp   = cell(1,nblev);
for j = 1:nblev
    k = levels(j);
    tmp{j} = coefs(first(k):last(k));
end

if nargout>0
   if (nargout==1 && nblev>1) || cellFLAG
       varargout{1} = tmp;
   else
       varargout = tmp;
   end
end
