function [WEIGHTS,INTERCEPT]=FDA_TRAIN(SAMPLES,LABELS);
%Use the input data to train a Fisher linear classifier
%USAGE: [WEIGHTS,INTERCEPT]=FDA_TRAIN(SAMPLES,LABELS)
%INPUT:
%SAMPLES is a matrix for the training data, each column is a data sample,
%LABELS is a row vector containing the corresponding label for each data
%sample.
%OUTPUT:
%WEIGHTS is a row vector of the weights for projecting the data space into
%1-D with the best direction to seperate the two classes for linear
%classification, INTERCEPT is a paramter which is used to make the
%classification border to 0.
%
%See also: FDA_TEST
%
% Dan.Zhang 2006-08-17
% d-zhang@mails.tsinghua.edu.cn

if(nargin~=2)
    fprintf('Error: Not the Correct Input.\n');
    return;
end
ClassName=unique(LABELS);
if(length(ClassName)~=2)
    fprintf('Error: Only For 2 Class Problem.\n');
    return;
end
SampleNum=size(SAMPLES,2);
LabelNum=size(LABELS,2);
if(LabelNum~=SampleNum)
    fprintf('Error: SAMPLES and LABELS mismatch.\n');
    return;
end
class1=SAMPLES(:,find(LABELS==ClassName(1)))';
class2=SAMPLES(:,find(LABELS==ClassName(2)))';
m1=mean(class1,1);
m2=mean(class2,1);
S1=0;
S2=0;
[count1 dim1]=size(class1);
for i=1:count1
    S1=S1+(class1(i,:)-m1)'*(class1(i,:)-m1);
end
[count2 dim2]=size(class2);
for i=1:count2
    S2=S2+(class2(i,:)-m2)'*(class2(i,:)-m2);
end
Sw=S1+S2;
W=Sw^(-1)*squeeze(m1-m2)';
y1=0;
y2=0;
for i=1:count1
    s_y1(i)=W'*class1(i,:)';
end
for i=1:count2
    s_y2(i)=W'*class2(i,:)';
end
w01=1;
w02=1;
y1=mean(s_y1);
y2=mean(s_y2);
y0=(w02*y1+w01*y2)/(w01+w02);

WEIGHTS=W';
INTERCEPT=y0;

if(isnumeric(ClassName(1)))
    output_values=WEIGHTS*SAMPLES-INTERCEPT;
    if(sign(max(output_values(find(LABELS==ClassName(1)))))~=sign(ClassName(1)))
        WEIGHTS=-WEIGHTS;
        INTERCEPT=-INTERCEPT;
    end
end


