function LABEL_TEST=FDA_TEST(SAMPLES,WEIGHTS,INTERCEPT);
%Use the trained Fisher linear classifier to classify data
%USAGE: LABEL_TEST=FDA_TEST(SAMPLES,WEIGHTS,INTERCEPT)
%INPUT:
%SAMPLES is a matrix for the data to be classified, each column is a data
%sample, [WEIGHTS,INTERCEPT] are parameters for the classifier obtained by
%the training process from 'FDA_TRAIN'
%OUTPUT:
%LABEL_TEST is a row vector of the classification results for SAMPLES, 
%the label will be given as -1/1 for the two classes
%
%See also: FDA_TRAIN
%
% Dan.Zhang 2006-08-17
% d-zhang@mails.tsinghua.edu.cn

if(nargin~=3)
    fprintf('Error: Not the Correct Input.\n');
    return;
end
DimNum=size(SAMPLES,1);
WeiNum=size(WEIGHTS,2);
if(DimNum~=WeiNum)
    fprintf('Error: SAMPLES and WEIGHTS mismatch.\n');
    return;
end 

LABEL_TEST=WEIGHTS*SAMPLES-INTERCEPT;
LABEL_TEST(find(LABEL_TEST>=0))=1;
LABEL_TEST(find(LABEL_TEST<0))=-1;
