function [ cepsgram ] = dsp2015_get_ceps(signal, samp_rate, windurmax, windurmin, stepdur, cw)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

siglen=length(signal);

% windurmax=3.00;
% windurmin=0.80;
% windurmin=0.8;
% stepdur=0.3;

% fcut_ceps=128;%64;%32;%16;%128;%64;%Hz
lagmin=windurmin/2;
lagmax=windurmax/2;
lagcap=lagmax;

% get cropwin stack (cropwin of diff sizes)
% cw=MSCM_Get_CropWin(samp_rate,fcut_ceps,lagmin,lagcap);

lagsizemin=round(lagmin*samp_rate);
lagsizemax=round(lagmax*samp_rate);
lagsizecap=round(lagcap*samp_rate);
winsizemin=lagsizemin*2;
winsizemax=lagsizemax*2;
winsizecap=lagsizecap*2;

% get time win of diff sizes
% for iLag=lagsizemin:lagsizecap
%     hw.HanWin{iLag}=hanning(iLag*2);
% end;

hw.HanWin{lagsizecap}=hanning(lagsizecap*2);

stepsize=round(stepdur*samp_rate);

nstep=floor((siglen-winsizecap)/stepsize)+1;

cepsgram=zeros(nstep,lagsizemax);%ceps

for iStep=1:nstep
    %get datawin for ecg and bp
    wincenter_l=(iStep-1)*stepsize+lagsizecap;
    wincenter_r=wincenter_l+1;
    
    widx_start=wincenter_l-lagsizecap+1;
    widx_end=wincenter_r+lagsizecap-1;
    datawin=signal(widx_start:widx_end);
    
    %get ceps for ecg and bp
    y1=datawin(1:lagsizecap*2);
    y1=y1-mean(y1);
    y2=abs(fft(y1.*hw.HanWin{lagsizecap}'));
    y3=log10(y2);
    y4=real(ifft(y3.*cw.CropWin{lagsizecap}'));
    
    cepsgram(iStep,lagsizemin:lagsizecap)=y4(lagsizemin+1:lagsizecap+1);
end;

end