function [ cw ] = dsp2015_MSCM_Get_CropWin( F_samp, F_cut, Lag_min, Lag_max )
%MSCM_Get_CropWin for max lag only
%   F_samp (Hz)
%   F_cut (Hz)
%   Lag_min (s) 
%   Lag_max (s)

F_nq=F_samp/2;
CropRatio=F_nq/F_cut;
HalfWinSize_min=round(Lag_min*F_samp);
HalfWinSize_max=round(Lag_max*F_samp);

cw.Fs=F_samp;
cw.Fcut=F_cut;
cw.HWSmin=HalfWinSize_min;
cw.HWSmax=HalfWinSize_max;

for hws=HalfWinSize_max:HalfWinSize_max
    winsize=hws*2;
    halfcropsize=round(hws/CropRatio);
    cropsize=halfcropsize*2;

    cropwin=zeros(winsize,1);
    cropwin(1)=1;%DC
    if cropsize<=winsize
        tempwin=hanning(cropsize+1);%single center point
        cropwin(1+1:1+halfcropsize)=tempwin(halfcropsize+2:cropsize+1);%positive freq
        cropwin(winsize-halfcropsize+1:winsize)=tempwin(1:halfcropsize);%negative freq
    elseif cropsize>winsize
        tempwin=hanning(cropsize+1);%single center point
        cropwin(1+1:1+hws)=tempwin(halfcropsize+2:halfcropsize+hws+1);%positive freq
        cropwin(winsize-hws+1:winsize)=tempwin(halfcropsize-hws+1:halfcropsize);
    end;
    
    cw.CropWin{hws}=cropwin;
            
end;

end