function alarmResult=chall_exp(recordName,alarm_type)
% load('Groundtruth');
% num_train=length(GOLD{1});
% load('Groundtruth_split');
% num_as_1=length(GOLD_AS_1{1});
% num_as_0=length(GOLD_AS_0{1});
% num_eb_1=length(GOLD_EB_1{1});
% num_eb_0=length(GOLD_EB_0{1});
% num_et_1=length(GOLD_ET_1{1});
% num_et_0=length(GOLD_ET_0{1});
% num_vt_1=length(GOLD_VT_1{1});
% num_vt_0=length(GOLD_VT_0{1});
% num_vf_1=length(GOLD_VF_1{1});
% num_vf_0=length(GOLD_VF_0{1});
% num_lead2=0;
% num_lead5=0;
% alarm_type='Asystole';
% alarm_type='Bradycardia';
% alarm_type='Tachycardia';
% alarm_type='Ventricular_Tachycardia';
% alarm_type='Ventricular_Flutter_Fib';

%% GRAND LOOP START
% for i=1:num_et_1%5%num_train%10%num_as_1
    
    
%     recordName=GOLD{1}{i};

%     recordName=GOLD_AS_1{1}{i};alarm_type='Asystole';
%     recordName=GOLD_AS_0{1}{i};alarm_type='Asystole';

%     recordName=GOLD_EB_1{1}{i};alarm_type='Bradycardia';
%     recordName=GOLD_EB_0{1}{i};alarm_type='Bradycardia';

%     recordName=GOLD_ET_1{1}{i};alarm_type='Tachycardia';
%     recordName=GOLD_ET_0{1}{i};alarm_type='Tachycardia';

%     recordName=GOLD_VT_1{1}{i};alarm_type='Ventricular_Tachycardia';
%     recordName=GOLD_VT_0{1}{i};alarm_type='Ventricular_Tachycardia';

%     recordName=GOLD_VF_1{1}{i};alarm_type='Ventricular_Flutter_Fib';
%     recordName=GOLD_VF_0{1}{i};alarm_type='Ventricular_Flutter_Fib';


    [~,signal,samp_rate,siginfo]=rdmat(recordName);
    signal(isnan(signal))=0;
    signal=resample(signal,125,samp_rate);
    samp_rate=125;

    [B_ecg,A_ecg] = butter(12,40/samp_rate);
    signal_ecg=filtfilt(B_ecg,A_ecg,signal(:,1:2));
    siglen=size(signal_ecg,1);

    description=squeeze(struct2cell(siginfo));
    description=description(4,:);
    abp_ind=get_index(description,'ABP');
    ppg_ind=get_index(description,'PLETH');
    if ~isempty(abp_ind)
        signal_abp=signal(:,abp_ind);
    else
        signal_abp=[];
    end
    if ~isempty(ppg_ind)
        signal_ppg=signal(:,ppg_ind);
    else
        signal_ppg=[];
    end
    
    switch alarm_type
        case 'Asystole'
            % if the signal quality is good enough and the maximum RR interval
            % is less than the Asystole threshold, set the alarm as 'F'
            %             if (abpsqi>=sqi_th && max_rr_abp<ASY_th) || (ppgsqi>=sqi_th && max_rr_ppg<ASY_th)
            %                 alarmResult=0;
            %             end
            result=challenge_check_asystole(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
            
        case 'Bradycardia'
            % if the signal quality is good enough and the low heart rate
            % is greater than the Bradycardia threshold, set the alarm as 'F'
            %             if (abpsqi>=sqi_th && low_hr_abp-tolerance>BRA_th) || (ppgsqi>=sqi_th && low_hr_ppg-tolerance>BRA_th)
            %                 alarmResult=0;
            %             end
            result=challenge_check_bradycardia(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);

        case 'Tachycardia'
            % if the signal quality is good enough and the high heart rate
            % is less than the Tachycardia threshold, set the alarm as 'F'
            %             if (abpsqi>=sqi_th && high_hr_abp+tolerance<TAC_th) || (ppgsqi>=sqi_th && high_hr_ppg+tolerance<TAC_th)
            %                 alarmResult=0;
            %             end
            result=challenge_check_tachycardia(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
            
        case 'Ventricular_Tachycardia'
            % suppress false alarm using hr_max & sqi
            %             if (abpsqi>=sqi_th && hr_max_abp+tolerance<VTA_th) || (ppgsqi>=sqi_th && hr_max_ppg+tolerance<VTA_th)
            %                 alarmResult=0;
            %             end
%             result=challenge_check_VT(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
            result=challenge_check_tachycardia(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
        case 'Ventricular_Flutter_Fib'
            % suppress false alarm using hr_max & sqi
            %             if (abpsqi>=sqi_th && hr_max_abp+tolerance<VFB_th) || (ppgsqi>=sqi_th && hr_max_ppg+tolerance<VFB_th)
            %                 alarmResult=0;
            %             end
%             result=challenge_check_VF(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
            result=challenge_check_asystole(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen);
        otherwise
            error(['Unknown alarm type: ' alarm_type])
    end

    windurmin=0.2;
    lagmin=windurmin/2;
    
    %step size and segment size
    stepdur_seg=0.04;%0.25;
    stepdur_seg=floor(samp_rate*stepdur_seg)/samp_rate;%make it integer
    stepsize=round(stepdur_seg*samp_rate);
    windurmax_seg=4;%4;%16;%4;%segment of 4 seconds
        
    lagmax_seg=windurmax_seg/2;
    show_lagsize=round(lagmax_seg*samp_rate);%considered lag range

    alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
    
    cw_seg_32=dsp2015_MSCM_Get_CropWin(samp_rate,32,lagmin,lagmax_seg);
    cw_seg_16=dsp2015_MSCM_Get_CropWin(samp_rate,16,lagmin,lagmax_seg);

    cepsgram_ecg1 = dsp2015_get_ceps(signal_ecg(alarm_window,1)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);
    cepsgram_ecg2 = dsp2015_get_ceps(signal_ecg(alarm_window,2)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);


%     figure
%     subplot(121);
%     imagesc(cepsgram_ecg1);
%     subplot(122);
%     imagesc(cepsgram_ecg2);
    
    alarmResult=result;

%     figure
%     if ~isempty(abp_ind)
%         cepsgram_abp = dsp2015_get_ceps(signal(alarm_window,abp_ind)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
%         subplot(121);
%         imagesc(cepsgram_abp);
%     end
%     if ~isempty(ppg_ind)
%         cepsgram_ppg = dsp2015_get_ceps(signal(alarm_window,ppg_ind)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
%         subplot(122);
%         imagesc(cepsgram_ppg);
%     end
    
%     lead2_ind=get_index(description,'II');
%     lead5_ind=get_index(description,'V');

    
%     if ~isempty(lead2_ind)
%         num_lead2=num_lead2+1;
%     end
%     if ~isempty(lead5_ind)
%         num_lead5=num_lead5+1;
%     end
%     if isempty(lead2_ind) || isempty(lead5_ind)
%         recordName
%         description
%     end
    
%     i
%     description
    
%     figure
%     subplot(4,1,1);
%     plot(signal_ecg(:,1));
%     subplot(4,1,2);
%     plot(signal_ecg(:,2));
%     subplot(4,1,3);
%     if ~isempty(abp_ind)
%         plot(signal(:,abp_ind));
%     end
%     subplot(4,1,4);
%     if ~isempty(ppg_ind)
%         plot(signal(:,ppg_ind));
%     end
    
% end

end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end
end

%% Asystole
function result=challenge_check_asystole(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen)
result=1;%default true alarm

windurmin=0.2;
lagmin=windurmin/2;
lagsizemin=round(lagmin*samp_rate);
windurmax_seg=3.2;%4;%16;%4;%segment of 4 seconds
lagmax_seg=windurmax_seg/2;
lagsizemax_seg=round(lagmax_seg*samp_rate);
windurmax_dyn=3.2;

%step size and segment size
stepdur_seg=0.04;%0.25;
stepdur_seg=floor(samp_rate*stepdur_seg)/samp_rate;%make it integer
stepsize=round(stepdur_seg*samp_rate);

alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(0*samp_rate)+1:round(300*samp_rate);

cw_seg_32=dsp2015_MSCM_Get_CropWin(samp_rate,32,lagmin,lagmax_seg);
cw_seg_16=dsp2015_MSCM_Get_CropWin(samp_rate,16,lagmin,lagmax_seg);

cepsgram_ecg1 = dsp2015_get_ceps(signal_ecg(alarm_window,1)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);
cepsgram_ecg2 = dsp2015_get_ceps(signal_ecg(alarm_window,2)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);

ceps_peak_ecg1=get_ceps_peak(cepsgram_ecg1,lagsizemin,lagsizemax_seg);
ceps_peak_ecg2=get_ceps_peak(cepsgram_ecg2,lagsizemin,lagsizemax_seg);

sig_dyn_ecg1 = get_signal_dyn(signal_ecg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
sig_dyn_ecg2 = get_signal_dyn(signal_ecg(alarm_window,2)', samp_rate, windurmax_dyn, stepdur_seg);

nstep=size(cepsgram_ecg1,1);
goodflag_ecg1=zeros(nstep,1);
goodflag_ecg2=zeros(nstep,1);


if ~isempty(signal_abp)
    cepsgram_abp = dsp2015_get_ceps(signal_abp(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_abp=get_ceps_peak(cepsgram_abp,lagsizemin,lagsizemax_seg);
    sig_dyn_abp = get_signal_dyn(signal_abp(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_abp =zeros(2,2);
    ceps_peak_abp=zeros(2,2);
    sig_dyn_abp =zeros(2,2);
    
end

if ~isempty(signal_ppg)
    cepsgram_ppg = dsp2015_get_ceps(signal_ppg(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_ppg=get_ceps_peak(cepsgram_ppg,lagsizemin,lagsizemax_seg);
    sig_dyn_ppg = get_signal_dyn(signal_ppg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_ppg =zeros(2,2);
    ceps_peak_ppg=zeros(2,2);
    sig_dyn_ppg = zeros(2,2);
end


thres_ecg_mag=0.02;
thres_leeway=2;
thres_diff=2;

for i=1:nstep
    lw_st=i-thres_leeway;
    lw_en=i+thres_leeway;
    if lw_st<1; lw_st=1; end;
    if lw_en>nstep; lw_en=nstep; end;
    %-------------------------------------
    if (ceps_peak_ecg1(i,2) > thres_ecg_mag) && (ceps_peak_ecg1(i,1) > lagsizemin) && (ceps_peak_ecg1(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ecg2(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg1(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            end
        end        
    end
    
    
    if (ceps_peak_ecg2(i,2) > thres_ecg_mag)  && (ceps_peak_ecg2(i,1) > lagsizemin) && (ceps_peak_ecg2(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ecg1(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg2(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            end
        end        
    end
    
    ok=1;
end

thres_true_alarm_asys=round((4-windurmax_seg)/stepdur_seg);

maxgap_ecg1=get_max_gap(goodflag_ecg1);
maxgap_ecg2=get_max_gap(goodflag_ecg2);

if (maxgap_ecg1<thres_true_alarm_asys) || (maxgap_ecg2<thres_true_alarm_asys)
    result=0;%%% false alarm claimed
end

% figure
% subplot(421);
% plot(ceps_peak_ecg1(:,1));hold on;
% plot(ceps_peak_ecg2(:,1),'r');hold off;
% subplot(422);
% plot(ceps_peak_ecg1(:,2));hold on;
% plot(ceps_peak_ecg2(:,2),'r');hold off;
% subplot(423);
% plot(sig_dyn_ecg1(:,1));hold on;
% plot(sig_dyn_ecg2(:,1),'r');hold off;
% subplot(424);
% plot(sig_dyn_ecg1(:,2));hold on;
% plot(sig_dyn_ecg2(:,2),'r');hold off;
% 
% subplot(425);
% plot(ceps_peak_abp(:,1));hold on;
% plot(ceps_peak_ppg(:,1),'r');hold off;
% subplot(426);
% plot(ceps_peak_abp(:,2));hold on;
% plot(ceps_peak_ppg(:,2),'r');hold off;
% subplot(427);
% plot(sig_dyn_abp(:,1));hold on;
% plot(sig_dyn_ppg(:,1),'r');hold off;
% subplot(428);
% plot(sig_dyn_abp(:,2));hold on;
% plot(sig_dyn_ppg(:,2),'r');hold off;

ok=1;
end

function maxgap=get_max_gap(goodflag)
nflag=length(goodflag);
maxgap=0;
gap_st=0;
curgap=0;
for i=1:nflag
    if goodflag(i)==1
        gap_st=i;
        if curgap>maxgap
            maxgap=curgap;
        end
        curgap=0;
    else
        curgap=curgap+1;
    end
    
end
if curgap>maxgap
    maxgap=curgap;
end
end

function sig_dyn = get_signal_dyn(signal, samp_rate, windur, stepdur)
siglen=length(signal);
winsize=round(windur*samp_rate);
stepsize=round(stepdur*samp_rate);
nstep=floor((siglen-winsize)/stepsize)+1;
signal_grad=zeros(siglen,1);
signal_grad(2:siglen-1)=signal(3:siglen)-signal(1:siglen-2);
sig_dyn=zeros(nstep,2);
for i=1:nstep
    offset=(i-1)*stepsize;
    sig_dyn(i,1)=max(signal(offset+1:offset+winsize))-min(signal(offset+1:offset+winsize));
    sig_dyn(i,2)=max(signal_grad(offset+1:offset+winsize))-min(signal_grad(offset+1:offset+winsize));
end

end
function ceps_peak_track=get_ceps_peak(cepsgram,lagmin,lagmax)
nceps=size(cepsgram,1);
ceps_peak_track=zeros(nceps,2);
for i=1:nceps
   [mv,mi]=max(cepsgram(i,lagmin:lagmax)); 
   mi=mi+lagmin+1;
   ceps_peak_track(i,1)=mi;
   ceps_peak_track(i,2)=mv;
end
    
end

%% Bradycardia
function result=challenge_check_bradycardia(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen)
result=1;%default true alarm

windurmin=0.2;
lagmin=windurmin/2;
lagsizemin=round(lagmin*samp_rate);
windurmax_seg=3.2;%4;%16;%4;%segment of 4 seconds
lagmax_seg=windurmax_seg/2;
lagsizemax_seg=round(lagmax_seg*samp_rate);
windurmax_dyn=3.2;

%step size and segment size
stepdur_seg=0.04;%0.25;
stepdur_seg=floor(samp_rate*stepdur_seg)/samp_rate;%make it integer
stepsize=round(stepdur_seg*samp_rate);

alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(0*samp_rate)+1:round(300*samp_rate);

cw_seg_32=dsp2015_MSCM_Get_CropWin(samp_rate,32,lagmin,lagmax_seg);
cw_seg_16=dsp2015_MSCM_Get_CropWin(samp_rate,16,lagmin,lagmax_seg);

cepsgram_ecg1 = dsp2015_get_ceps(signal_ecg(alarm_window,1)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);
cepsgram_ecg2 = dsp2015_get_ceps(signal_ecg(alarm_window,2)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);

ceps_peak_ecg1=get_ceps_peak(cepsgram_ecg1,lagsizemin,lagsizemax_seg);
ceps_peak_ecg2=get_ceps_peak(cepsgram_ecg2,lagsizemin,lagsizemax_seg);

sig_dyn_ecg1 = get_signal_dyn(signal_ecg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
sig_dyn_ecg2 = get_signal_dyn(signal_ecg(alarm_window,2)', samp_rate, windurmax_dyn, stepdur_seg);

nstep=size(cepsgram_ecg1,1);
goodflag_ecg1=zeros(nstep,1);
goodflag_ecg2=zeros(nstep,1);


if ~isempty(signal_abp)
    cepsgram_abp = dsp2015_get_ceps(signal_abp(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_abp=get_ceps_peak(cepsgram_abp,lagsizemin,lagsizemax_seg);
    sig_dyn_abp = get_signal_dyn(signal_abp(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_abp =zeros(2,2);
    ceps_peak_abp=zeros(2,2);
    sig_dyn_abp =zeros(2,2);
    
end

if ~isempty(signal_ppg)
    cepsgram_ppg = dsp2015_get_ceps(signal_ppg(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_ppg=get_ceps_peak(cepsgram_ppg,lagsizemin,lagsizemax_seg);
    sig_dyn_ppg = get_signal_dyn(signal_ppg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_ppg =zeros(2,2);
    ceps_peak_ppg=zeros(2,2);
    sig_dyn_ppg = zeros(2,2);
end


thres_ecg_mag=0.02;
thres_leeway=2;
thres_diff=2;

for i=1:nstep
    lw_st=i-thres_leeway;
    lw_en=i+thres_leeway;
    if lw_st<1; lw_st=1; end;
    if lw_en>nstep; lw_en=nstep; end;
    %-------------------------------------
    if (ceps_peak_ecg1(i,2) > thres_ecg_mag) && (ceps_peak_ecg1(i,1) > lagsizemin) && (ceps_peak_ecg1(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ecg2(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg1(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            end
        end        
    end
    
    
    if (ceps_peak_ecg2(i,2) > thres_ecg_mag)  && (ceps_peak_ecg2(i,1) > lagsizemin) && (ceps_peak_ecg2(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ecg1(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg2(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            end
        end        
    end
    
    ok=1;
end

thres_true_alarm_eb=round((7.5-windurmax_seg)/stepdur_seg);

[meanlag_ecg1,nread1]=get_mean_lag(goodflag_ecg1,ceps_peak_ecg1,thres_true_alarm_eb);
[meanlag_ecg2,nread2]=get_mean_lag(goodflag_ecg2,ceps_peak_ecg2,thres_true_alarm_eb);

if ((nread1<20) || (meanlag_ecg1<187*0.8)) && ((nread2<20) || (meanlag_ecg2<187*0.8))
    result=0;%%% false alarm claimed
end

end

function [meanlag,nread]=get_mean_lag(goodflag,ceps_peak,thres_true_alarm_eb)
meanlag=0;
nflag=length(goodflag);
ncheck=nflag-thres_true_alarm_eb-1;
nread=0;
for i=1:ncheck
    curflag=goodflag(i:i+thres_true_alarm_eb);
    curlag=ceps_peak(i:i+thres_true_alarm_eb,1);
    curnread=sum(curflag);
    if curnread>0
        curmeanlag=mean(curlag(curflag==1));
        if meanlag<curmeanlag
            meanlag=curmeanlag;
            nread=curnread;
        end
    end
end
end
function result=challenge_check_tachycardia(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen)
result=1;%default true alarm

windurmin=0.2;
lagmin=windurmin/2;
lagsizemin=round(lagmin*samp_rate);
windurmax_seg=3.2;%4;%16;%4;%segment of 4 seconds
lagmax_seg=windurmax_seg/2;
lagsizemax_seg=round(lagmax_seg*samp_rate);
windurmax_dyn=3.2;

%step size and segment size
stepdur_seg=0.04;%0.25;
stepdur_seg=floor(samp_rate*stepdur_seg)/samp_rate;%make it integer
stepsize=round(stepdur_seg*samp_rate);

alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(290*samp_rate)+1:round(300*samp_rate);
% alarm_window=round(0*samp_rate)+1:round(300*samp_rate);

cw_seg_32=dsp2015_MSCM_Get_CropWin(samp_rate,32,lagmin,lagmax_seg);
cw_seg_16=dsp2015_MSCM_Get_CropWin(samp_rate,16,lagmin,lagmax_seg);

cepsgram_ecg1 = dsp2015_get_ceps(signal_ecg(alarm_window,1)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);
cepsgram_ecg2 = dsp2015_get_ceps(signal_ecg(alarm_window,2)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_32);

ceps_peak_ecg1=get_ceps_peak(cepsgram_ecg1,lagsizemin,lagsizemax_seg);
ceps_peak_ecg2=get_ceps_peak(cepsgram_ecg2,lagsizemin,lagsizemax_seg);

sig_dyn_ecg1 = get_signal_dyn(signal_ecg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
sig_dyn_ecg2 = get_signal_dyn(signal_ecg(alarm_window,2)', samp_rate, windurmax_dyn, stepdur_seg);

nstep=size(cepsgram_ecg1,1);
goodflag_ecg1=zeros(nstep,1);
goodflag_ecg2=zeros(nstep,1);


if ~isempty(signal_abp)
    cepsgram_abp = dsp2015_get_ceps(signal_abp(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_abp=get_ceps_peak(cepsgram_abp,lagsizemin,lagsizemax_seg);
    sig_dyn_abp = get_signal_dyn(signal_abp(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_abp =zeros(2,2);
    ceps_peak_abp=zeros(2,2);
    sig_dyn_abp =zeros(2,2);
    
end

if ~isempty(signal_ppg)
    cepsgram_ppg = dsp2015_get_ceps(signal_ppg(alarm_window)', samp_rate, windurmax_seg, windurmin, stepdur_seg, cw_seg_16);
    ceps_peak_ppg=get_ceps_peak(cepsgram_ppg,lagsizemin,lagsizemax_seg);
    sig_dyn_ppg = get_signal_dyn(signal_ppg(alarm_window,1)', samp_rate, windurmax_dyn, stepdur_seg);
else
    cepsgram_ppg =zeros(2,2);
    ceps_peak_ppg=zeros(2,2);
    sig_dyn_ppg = zeros(2,2);
end


thres_ecg_mag=0.02;
thres_leeway=2;
thres_diff=2;

for i=1:nstep
    lw_st=i-thres_leeway;
    lw_en=i+thres_leeway;
    if lw_st<1; lw_st=1; end;
    if lw_en>nstep; lw_en=nstep; end;
    %-------------------------------------
    if (ceps_peak_ecg1(i,2) > thres_ecg_mag) && (ceps_peak_ecg1(i,1) > lagsizemin) && (ceps_peak_ecg1(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ecg2(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg1(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg1(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg1(i)=1;
                end
            end
        end        
    end
    
    
    if (ceps_peak_ecg2(i,2) > thres_ecg_mag)  && (ceps_peak_ecg2(i,1) > lagsizemin) && (ceps_peak_ecg2(i,1) < lagsizemax_seg) 
        ee_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ecg1(lw_st:lw_en,1)));
        if ee_diff<thres_diff
            goodflag_ecg2(i)=1;
        else
            if ~isempty(signal_abp)
                ea_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_abp(lw_st:lw_en,1)));
                if ea_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            elseif ~isempty(signal_ppg)
                ep_diff=min(abs(ceps_peak_ecg2(i,1)-ceps_peak_ppg(lw_st:lw_en,1)));
                if ep_diff<thres_diff
                    goodflag_ecg2(i)=1;
                end
            end
        end        
    end
    
    ok=1;
end

thres_true_alarm_et=round((7.5-windurmax_seg)/stepdur_seg);

[meanlag_ecg1,nread1]=get_mean_lag_et(goodflag_ecg1,ceps_peak_ecg1,thres_true_alarm_et);
[meanlag_ecg2,nread2]=get_mean_lag_et(goodflag_ecg2,ceps_peak_ecg2,thres_true_alarm_et);

if ((nread1<50) || (meanlag_ecg1>53/0.8)) && ((nread2<50) || (meanlag_ecg2>53/0.8))
    result=0;%%% false alarm claimed
end


end

function [meanlag,nread]=get_mean_lag_et(goodflag,ceps_peak,thres_true_alarm_eb)
meanlag=125;
nflag=length(goodflag);
ncheck=nflag-thres_true_alarm_eb-1;
nread=0;
for i=1:ncheck
    curflag=goodflag(i:i+thres_true_alarm_eb);
    curlag=ceps_peak(i:i+thres_true_alarm_eb,1);
    curnread=sum(curflag);
    if curnread>0
        curmeanlag=mean(curlag(curflag==1));
        if meanlag>curmeanlag
            meanlag=curmeanlag;
            nread=curnread;
        end
    end
end
end


function result=challenge_check_VT(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen)
result=1;

end

function result=challenge_check_VF(signal_ecg,signal_abp,signal_ppg,samp_rate,siglen)
result=1;

end
