function alarmResult=ventricular_t_problem_20150407(signal, recordName, Fs)

%%
% set valid data segment for decision making, 16s before the alarm
alarmResult=1;
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm
N1_d=N_d-Fs*60+1;
% 
gqrs(recordName(end-4:end),[],[],1);
% gqrs(recordName,[],[],1);
ann_ECG_1=[];
try
    ann_ECG_1=rdann(recordName(end-4:end),'qrs');
end
gqrs(recordName(end-4:end),[],[],2);
% gqrs(recordName,[],[],2);
ann_ECG_2=[];
try 
    ann_ECG_2=rdann(recordName(end-4:end),'qrs');
end

% clear D Sk S N k a b;
N = 32+1;
b = ones(1,N)/N; a = 1;
for k=1:2
    D = diff(signal(:,k)).^2;
    Sk = filtfilt(b,a,D);
    S(:,k) = Sk/std(Sk);
end
S(N_d,1)=S(end,1);
S(N_d,2)=S(end,2);
% plot(S(N1_d:N_d,1));
% line( [(ann_ECG_1(find(ann_ECG_1>N1_d))-N1_d) (ann_ECG_1(find(ann_ECG_1>N1_d))-N1_d)],[0 1], 'Color', 'red');
n_ecg_beats_1=intersect(find(ann_ECG_1>=N1_d),find(ann_ECG_1<=N0_d));
n_ecg_beats_1e=intersect(find(ann_ECG_1>=N0_d),find(ann_ECG_1<=N_d));
ecg1_vent_n=-1;
if length(n_ecg_beats_1)>25 && length(n_ecg_beats_1e)>4
    ecg_1=zeros(2,length(n_ecg_beats_1)-1);
    for j=2:length(n_ecg_beats_1)
        ecg_1(1,j-1)=S(ann_ECG_1(n_ecg_beats_1(j)),1);
        ecg_1(2,j-1)=ann_ECG_1(n_ecg_beats_1(j))-ann_ECG_1(n_ecg_beats_1(j-1));
    end
    ecg_1=mean(ecg_1');
    ecg_1e=zeros(2,length(n_ecg_beats_1e)-1);
    for j=2:length(n_ecg_beats_1e)
        ecg_1e(1,j-1)=S(ann_ECG_1(n_ecg_beats_1e(j)),1);
        ecg_1e(2,j-1)=ann_ECG_1(n_ecg_beats_1e(j))-ann_ECG_1(n_ecg_beats_1e(j-1));
    end
    ecg1_vent_n=0;
    for j=1:length(ecg_1e)-4
        if ((abs(ecg_1(1)-mean(ecg_1e(1,j:j+4)))>ecg_1(1)*0.22 && abs(ecg_1(2)-mean(ecg_1e(2,j:j+4)))>ecg_1(2)*0.22) ...
           && abs(ecg_1(1)-mean(ecg_1e(1,j:j+4)))<ecg_1(1)*0.8) || ((abs(ecg_1(1)-mean(ecg_1e(1,j:j+4)))>ecg_1(1)*0.62 ...
            || abs(ecg_1(2)-mean(ecg_1e(2,j:j+4)))>ecg_1(2)*0.62) && abs(ecg_1(1)-mean(ecg_1e(1,j:j+4)))<ecg_1(1)*1)
            ecg1_vent_n=ecg1_vent_n+1;
        end
    end
end
n_ecg_beats_2=intersect(find(ann_ECG_2>=N1_d),find(ann_ECG_2<=N0_d));
n_ecg_beats_2e=intersect(find(ann_ECG_2>=N0_d),find(ann_ECG_2<=N_d));
ecg2_vent_n=-1;
if length(n_ecg_beats_2)>25 && length(n_ecg_beats_2e)>4
    ecg_2=zeros(2,length(n_ecg_beats_2)-1);
    for j=2:length(n_ecg_beats_2)
        ecg_2(1,j-1)=S(ann_ECG_2(n_ecg_beats_2(j)),2);
        ecg_2(2,j-1)=ann_ECG_2(n_ecg_beats_2(j))-ann_ECG_2(n_ecg_beats_2(j-1));
    end
    ecg_2=mean(ecg_2');
    ecg_2e=zeros(2,length(n_ecg_beats_2e)-1);
    for j=2:length(n_ecg_beats_2e)
        ecg_2e(1,j-1)=S(ann_ECG_2(n_ecg_beats_2e(j)),2);
        ecg_2e(2,j-1)=ann_ECG_2(n_ecg_beats_2e(j))-ann_ECG_2(n_ecg_beats_2e(j-1));
    end
    ecg2_vent_n=0;
    for j=1:length(ecg_2e)-4
        if ((abs(ecg_2(1)-mean(ecg_2e(1,j:j+4)))>ecg_2(1)*0.22 && abs(ecg_2(2)-mean(ecg_2e(2,j:j+4)))>ecg_2(2)*0.22) ...
            && abs(ecg_2(1)-mean(ecg_2e(1,j:j+4)))<ecg_2(1)*0.8) || ((abs(ecg_2(1)-mean(ecg_2e(1,j:j+4)))>ecg_2(1)*0.62 ...
            || abs(ecg_2(2)-mean(ecg_2e(2,j:j+4)))>ecg_2(2)*0.62) && abs(ecg_2(1)-mean(ecg_2e(1,j:j+4)))<ecg_2(1)*1)
            ecg2_vent_n=ecg2_vent_n+1;
        end
    end
end
if (ecg1_vent_n==0 || ecg2_vent_n==0) && abs(ecg1_vent_n-ecg2_vent_n)<4
    alarmResult=0;
end
