function [high_hr_ecg_1,high_hr_ecg_2]=tachycardia_problem_20150405(recordName, Fs)

%%
% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

gqrs(recordName(end-4:end),[],[],1);
ann_ECG_1=[];
try
    ann_ECG_1=rdann(recordName(end-4:end),'qrs');
end
gqrs(recordName(end-4:end),[],[],2);
ann_ECG_2=[];
try 
    ann_ECG_2=rdann(recordName(end-4:end),'qrs');
end

n_ecg_beats_1=intersect(find(ann_ECG_1>=N0_d),find(ann_ECG_1<=N_d));
n_ecg_beats_2=intersect(find(ann_ECG_2>=N0_d),find(ann_ECG_2<=N_d));

% calculate high heart reate of 17 consecutive beats for Tachycardia
high_hr_ecg_1=NaN;
high_hr_ecg_2=NaN;
if length(n_ecg_beats_1)>=17
    for i=1:length(n_ecg_beats_1)-16
        high_hr_ecg_1(i)=60*Fs/((ann_ECG_1(n_ecg_beats_1(i+16))-ann_ECG_1(n_ecg_beats_1(i)))/16);
    end
    high_hr_ecg_1(i+1)=60*Fs/((N_d-ann_ECG_1(n_ecg_beats_1(i+1)))/16);
end
high_hr_ecg_1=max(high_hr_ecg_1);
if length(n_ecg_beats_2)>=17
    for i=1:length(n_ecg_beats_2)-16
        high_hr_ecg_2(i)=60*Fs/((ann_ECG_2(n_ecg_beats_2(i+16))-ann_ECG_2(n_ecg_beats_2(i)))/16);
    end
    high_hr_ecg_2(i+1)=60*Fs/((N_d-ann_ECG_2(n_ecg_beats_2(i+1)))/16);    
end
high_hr_ecg_2=max(high_hr_ecg_2);