function [low_hr_ecg_1,low_hr_ecg_2]=bradycardia_problem_20150404(recordName, Fs)

%%
% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

gqrs(recordName(end-4:end),[],[],1);
ann_ECG_1=[];
try
    ann_ECG_1=rdann(recordName(end-4:end),'qrs');
end
gqrs(recordName(end-4:end),[],[],2);
ann_ECG_2=[];
try 
    ann_ECG_2=rdann(recordName(end-4:end),'qrs');
end

n_ecg_beats_1=intersect(find(ann_ECG_1>=N0_d),find(ann_ECG_1<=N_d));
n_ecg_beats_2=intersect(find(ann_ECG_2>=N0_d),find(ann_ECG_2<=N_d));

% calculate low heart rate of 5 consecutive beats for Bradycardia
low_hr_ecg_1=NaN;
low_hr_ecg_2=NaN;
if length(n_ecg_beats_1)>=5
    for i=1:length(n_ecg_beats_1)-4
        low_hr_ecg_1(i)=60*Fs/((ann_ECG_1(n_ecg_beats_1(i+4))-ann_ECG_1(n_ecg_beats_1(i)))/4);
    end
    low_hr_ecg_1(i+1)=60*Fs/((N_d-ann_ECG_1(n_ecg_beats_1(i+1)))/4);
end
low_hr_ecg_1=min(low_hr_ecg_1);
if length(n_ecg_beats_2)>=5
    for i=1:length(n_ecg_beats_2)-4
        low_hr_ecg_2(i)=60*Fs/((ann_ECG_2(n_ecg_beats_2(i+4))-ann_ECG_2(n_ecg_beats_2(i)))/4);
    end
    low_hr_ecg_2(i+1)=60*Fs/((N_d-ann_ECG_2(n_ecg_beats_2(i+1)))/4);    
end
low_hr_ecg_2=min(low_hr_ecg_2);
