function alarmResult=asystoles_problem_20150403(recordName, Fs, ASY_th)
% probleminiai signalai:
% 391.123.645
%%


alarmResult=1;
% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

gqrs(recordName(end-4:end),[],[],1);
ann_ECG_1=[];
try
    ann_ECG_1=rdann(recordName(end-4:end),'qrs');
end
gqrs(recordName(end-4:end),[],[],2);
ann_ECG_2=[];
try 
    ann_ECG_2=rdann(recordName(end-4:end),'qrs');
end

n_ecg_beats_1=intersect(find(ann_ECG_1>=N0_d),find(ann_ECG_1<=N_d));
n_ecg_beats_2=intersect(find(ann_ECG_2>=N0_d),find(ann_ECG_2<=N_d));

max_rr_ECG_1=NaN;
ecg_diff=[];
if length(n_ecg_beats_1)>=2
    ecg_diff=ann_ECG_1(n_ecg_beats_1);
    ecg_diff(end+1)=N_d;
    max_rr_ECG_1=max(diff(ecg_diff))/Fs;
end
ecg_diff=[];
max_rr_ECG_2=NaN;
if length(n_ecg_beats_2)>=2
    ecg_diff=ann_ECG_2(n_ecg_beats_2);
    ecg_diff(end+1)=N_d;
    max_rr_ECG_2=max(diff(ecg_diff))/Fs;
end
tolerance = 0.5;
if (max_rr_ECG_1<(ASY_th-tolerance)) || (max_rr_ECG_2<(ASY_th-tolerance)) || (max_rr_ECG_1<(ASY_th/2) && max_rr_ECG_2<(ASY_th/2) )
	alarmResult=0;
end
