%This script will search for all records and produce results
%
clear all; close all; %clc
data_dir=[pwd filesep];

%Add the function on this directory to the MATLAB path
%This is not permanent. This change is only valid for this session of
%MATLAB (will reset once MATLAB is restarted).
addpath(pwd)

% Progress?
tic; progress = 0;

fileExtension = '*.hea';
dirData = dir([pwd '/' fileExtension]); idList = {dirData.name}; N = length(idList);

% initializing result & gold standard array
results = zeros(N,1);
gs = zeros(N,1);

for n = 1:N
    [~, recordName, ~] = fileparts(idList{n});

    % Read .hea file (to return alarm type & gold standard)
    recordHeader = importdata([recordName '.hea'], '');
    goldS = recordHeader{ length(recordHeader) };    
    alarmT = recordHeader{ length(recordHeader) - 1 };    
    alarm_type = alarmT(2:end);
    
    gs(n) = 1;
    if (sum(goldS) == 1083)
        gs(n) = 0;
    end
    
    results(n) = challenge(recordName, alarm_type);
    progress = progress + 1;
end

display('')
display(['Alarm processed: ' mat2str(progress) ])
toc



% calculate score
tp = sum(gs == 1 & results == 1);
fn = sum(gs == 1 & results == 0);
fp = sum(gs == 0 & results == 1);
tn = sum(gs == 0 & results == 0);
score = (tp+ tn) / (tp + tn + fp + 5*fn);
display(['Total: ' mat2str(sum(tp + tn + fp + fn)) ]) 
display(['Score: ' mat2str(score) ])
display(['FN vs. FP: ' mat2str(fn) ' vs. ' mat2str(fp) ])









