function alarmResult = fcheck_v5(recordName,beat_loc,alarmResult,alarm_type,Fs,Nend,signal,ecg_ind)
% Submission Version 1: 1 Aug 2015 (SK)
% Modification made to code for Official Phase
% Submission Versiono 2: 3 Aug 2015 (SK)
% modification made to detection of VT - using signal cross-correlation to detect ventricular beats

% for debugging only
debug_flag=0;

% set valid data segment for decision making, last 16 secs of signal
Detection_start = 284;
Nlast = Detection_start*Fs;

% select the beats in the segment
beats_detect=[];
for i=1:size(beat_loc,1)
    if(beat_loc(i,1)>Nlast && beat_loc(i,1)<Nend)
        beats_detect=[beats_detect;beat_loc(i,1)];
    end
end

hr_max=NaN;
max_rr=NaN;
% calculate the heart rate
if length(beats_detect)>=2
    hr_max=60*Fs/min(diff(beats_detect));
    max_rr=max(diff(beats_detect))/Fs;
    % checking the interval of the last annotated beat to Nend (for Asystole)
    switch alarm_type
        case 'Asystole'
            temp_rr = (Nend - beats_detect(end,1))/Fs;
            max_rr = max(max_rr, temp_rr);
    end
end

% calculate low heart rate of 5 consecutive beats for Bradycardia
low_hr=NaN;
if length(beats_detect>=5)
    for i=1:length(beats_detect)-4
        low_hr(i)=60*Fs/((beats_detect(i+4)-beats_detect(i))/4);
    end
end
low_hr=min(low_hr);

% calculate high heart reate of 17 consecutive beats for Tachycardia
high_hr=NaN;
if length(beats_detect>=17)
    interval=diff(beats_detect); 
    % checking for 16 consecutive interval (3 Aug 15)
    for i=1:length(interval)-16
        high_hr(i)=60*Fs/mean_wo_max(interval(i:i+16)); 
    end
end
high_hr=max(high_hr);

% Alarm threshold (seconds)
ASY_th = 4;
BRA_th = 40;
TAC_th = 140;
VTA_th = 100;
VFB_th = 250;
tolerance = 5; % tolerance = 5 bmp

switch alarm_type
    case 'Asystole'
        % if the maximum RR interval is less than the Asystole threshold, set the alarm as 'F'
        if ( max_rr <ASY_th )
            % checking of the aystole should be performed using the RR
            % interval and comparing the RR interval to the end of the signal
            alarmResult=0;
        end
    case 'Bradycardia'
        % if the low heart rate is greater than the Bradycardia threshold, set the alarm as 'F'
        if ( low_hr-tolerance>BRA_th )
            alarmResult=0;
        end
    case 'Tachycardia'
        % if the high heart rate is less than the Tachycardia threshold, set the alarm as 'F'
        % if ( high_hr+tolerance<TAC_th )
        if ( high_hr+tolerance+1<TAC_th ) % using a tolerance of 6 bmp for tachycardia (3 Aug 15)    
            alarmResult=0;
        end
    case 'Ventricular_Tachycardia'
        % SK (3 Aug 15) 
        % calculate the signal cross-correlation to detect beats with abnormal waveform
        % identifying beat location from 4 mins 40 secs onwards
        % checking that ecg signal is of good quality; otherwise, assume to be a true alarm
        if(~isempty(ecg_ind))
            % ** using the interval from 4 mins 30 secs to 4 mins 40 secs **
            tcheck1 = 270*Fs; tcheck2 = 280*Fs;
            tindex = find(beat_loc >= tcheck1 & beat_loc <= tcheck2);
            chk_window = floor(Fs/5); % default window size of 50 for Fs = 250
            
            % using the first signal after 4 min 40 secs as the baseline signal
            % we are going to compare all the subsequent signals against the first signal
            % Assumptions: 
            % the first signal is representative of normal ECG profile
            % Ventricular beat has a ECG profile that is significantly different from this first signal
            % Additional check for size(tindex,1)
            if(~isempty(tindex))
                tsignal1 = signal((beat_loc(tindex(1,1),1)-chk_window):(beat_loc(tindex(1,1),1)+chk_window),ecg_ind);
                if(debug_flag==1)
                    figure(11);plot(tsignal1,'b-');hold on;grid on;
                    figure(12);hold on;grid on;
                end
                
                % ** looping through all signals in tindex
                tempdata1=[]; count=1;
                for j=2:size(tindex,1)
                    tsignal_vect = signal((beat_loc(tindex(j,1),1)-chk_window):(beat_loc(tindex(j,1),1)+chk_window),ecg_ind);
                    tempdata1(:,count)=xcorr(tsignal1, tsignal_vect);
                    count = count+1;
                end
                zz = skewness(tempdata1); zzmean=mean(zz); zzstd=std(zz);
                
                
                % looping through all ecg signals in tindex
                % computing the xcorr vector for all ecg signals compared to tsignal1 (index position 1)
                tempdata_comb=[]; count=1;
                for j=1:size(beats_detect,1)
                    % checking for out-of-bounds if the location of the ecg signal is very close to end of the recording
                    if(beats_detect(j,1)+chk_window > Nend)
                        tsignal_vect = signal((beats_detect(j,1)-chk_window):Nend,ecg_ind);
                    else
                        tsignal_vect = signal((beats_detect(j,1)-chk_window):(beats_detect(j,1)+chk_window),ecg_ind);
                    end
                    tempdata_comb(:,count) = xcorr(tsignal1, tsignal_vect);
                    if(debug_flag==1)
                        figure(12);plot(tempdata_comb(:,count));
                    end
                    count = count+1;
                end
                zz1 = skewness(tempdata_comb);
                
                %             sum_vect=[];
                %             % computing the symmetrical of the xcorr vector using a heuristic scalar measure
                %             % Note1: can replace this by computing the skewness measure instead
                %             for jj=1:size(tempdata_comb,2)
                %                 datavect = tempdata_comb(:,jj);
                %                 sum=0;count=1; sindex = size(tsignal1,1)-1;
                %                 for k=sindex:-1:1
                %                     k1 = sindex+count;
                %                     sum = sum + abs(datavect(k,1)-datavect(k1,1))/(datavect(k,1)+datavect(k1,1));
                %                     count =count+1;
                %                 end
                %                 sum_vect(1,jj)=sum;
                %             end
                
                % detecting the ventricular beats using the scalar value in sum_vect (size of sum_vect is 1 X N)
                % Using a scalar threshold of 10 to determine if the 2 signals are similiar
                % Need to detect at least 5 VT with heart rate higher than 100 bpm to declare the alarm as a true alarm
                VT_count = 0; scalar_threshold=20; VT_flag=0;
                zzstd_range = 4;
                %for j=1:size(sum_vect,2)
                % if(sum_vect(1,j)>scalar_threshold)
                for j=1:size(zz1,2)
                    if(zz1(1,j) > zzmean + zzstd_range * zzstd || zz1(1,j) < zzmean - zzstd_range * zzstd)
                        VT_count = VT_count + 1;
                        if(VT_count==1)
                            sindex = j;
                        end
                        if(VT_count>=5)
                            % computing the minimum interval for the N successive beats
                            tvect = beats_detect(sindex:j,1);
                            hr_max_VT=60*Fs/min(diff(tvect));
                            if(hr_max_VT + tolerance>=VTA_th)
                                VT_flag=1;
                                break;
                            end
                        end
                    else
                        % resetting VT_count
                        VT_count=0;
                    end
                end
                
                % suppress false alarm if VT_flag=0;
                if(VT_flag==0)
                    alarmResult=0;
                end
            end % end of if(~isempty(tindex)) loop
        end
        
     
    case 'Ventricular_Flutter_Fib'
        % suppress false alarm using hr_max 
        if ( hr_max + tolerance<VFB_th)
            alarmResult=0;
        end
    otherwise
        error(['Unknown alarm type: ' alarm_type])
end

% printing out the results
% fprintf('%s,%d\n', recordName, alarmResult);

function v=mean_wo_max(x)
    [~,c2]=max(x);
    x(c2)=[];
    v=mean(x);