function alarmResult = challenge(recordName,alarm_type)
% MATLAB code to determine beat location in last 30 secs & TRUE/FALSE alarm
% decision using last 16 secs
% Submission Version 2: 3 Aug 2015 (SK)
% Modification made to code for Official Phase
%
%
% (1)(a) Beat annotation using signal(s) (method):
%       1. ECG-1            (gqrs)
%       2. ECG-2            (gqrs)
%       3. ABP              (wabp)
%       4. PLETH            (wabp)
%       5. ECG-1 & ABP      (ann_signal_v4)
%       6. ECG-1 & PLETH    (ann_signal_v4)
%       7. ECG-2 & ABP      (ann_signal_v4) 
%       8. ECG-2 & PLETH    (ann_signal_v4)
%       9. ECG-1            (ann_signal_v4) (NOT REQUIRED)
%       10. ECG-2           (ann_signal_v4) (NOT REQUIRED)
% (2)(b) Decision making using last 16 secs of signal from (a)
% (3) Output alarmResult     
%
% suppress ALL warnings
%warning('off','all');


% Name of file containing answers
answers = 'answers.txt';


% Read .mat file (get all ECGs, ABP and PLETH signals)
[~, signal, Fs, siginfo] = rdmat(recordName);

% Print out record & signal description
display('')                                         %(TO BE DISABLE)
display(['Record Name: ' recordName ])              %(TO BE DISABLE)
display(['Alarm Type: ' alarm_type ])               %(TO BE DISABLE)

description = squeeze(struct2cell(siginfo)); description = description(4,:) %;

% Set sample range (use partial data: last 30 secs)
%Nstart = [];
Nstart = 270*Fs; Nend = 300*Fs;
[timeB, dateB] = wfdbtime(recordName, Nstart);	% converts sample index to WFDB Time	
[timeS, dateS] = wfdbtime(recordName, Nend);

% Check range (check for data quality: last 30 secs)
Ncheck = 270*Fs;    %  last 30 secs
samThres = 0.5;     % set sample threshold (process only if signal pts > 50%)
stdThres = 0.01;	% set standard deviation threshold (process only if signal pts standard deviation > 0.01)

% Quality check for each signal (good: 1 ; bad: 0)
quaC = [];
for ns = 1:length(description)
	if ( sum(isfinite(signal(Ncheck: Nend, ns))) > (length(Ncheck: Nend)*samThres) && sum(signal(Ncheck: Nend, ns) ~= 0) > (length(Ncheck: Nend)*samThres) && std(signal(Ncheck: Nend, ns)) > stdThres )	% check last 30 secs sample quality: (1: non NAN signal pts > threshold % ; 2: non zero value signal points > threshold % ; 3: std > 0)
	quaC = [quaC 1];
	else
	quaC = [quaC 0];
	end
end

display(['Signal Quality: ' mat2str(quaC)])              %(TO BE DISABLE)


% Determine which signals are in good quality & thus which function to use for searching beats interval (added by JC @ 05/08/2015)  
quaS = zeros(1, 8);
channel = NaN(1,4);     % channel for [ECG-1, ECG-2, ABP, PLETH]
if (quaC(1) == 1)
    quaS(1) = 1;	channel(1) = 1;
end
if (quaC(2) == 1)
    quaS(2) = 1;    channel(2) = 2;
end
if ( get_index(description, quaC, 'ABP') )
    quaS(3) = 1;    channel(3) = get_index(description, quaC, 'ABP');
end
if ( get_index(description, quaC, 'PLETH') )
    quaS(4) = 1;    channel(4) = get_index(description, quaC, 'PLETH');
end
quaS(5:6) = quaS(1) * quaS(3:4);    quaS(7:8) = quaS(2) * quaS(3:4);



% Parameter tuning 
% set qrs threshold for the annotation algorithm, threshold = 2.0 as
% default; can be altered (e.g. threshold = 2.0); may not need to alter
threshold = [];
switch alarm_type
    case 'Tachycardia'
        thres2 = 1;
    case 'Ventricular_Tachycardia'
        thres2 = .8;
        % discarding the PLETH and ABP signals for Ventricular_Tachycardia
        quaS(3:4) = 0;
    case 'Asystole'
        thres2 = .3;
    case 'Bradycardia'
        thres2 = .5;
    case 'Ventricular_Flutter_Fib'
        thres2 = .4;
end

display(['Channel for ECG-1: ' mat2str(channel(1))])        %(TO BE DISABLE)
display(['Channel for ECG-2: ' mat2str(channel(2))])        %(TO BE DISABLE)
display(['Channel for ABP: ' mat2str(channel(3))])          %(TO BE DISABLE)
display(['Channel for PLETH: ' mat2str(channel(4))])        %(TO BE DISABLE)
display(['Annotation method: ' mat2str(quaS)])              %(TO BE DISABLE)


% Initializing result array for updating output
results = zeros(8,1);


% ann. algo.
% Output: beat_loc * 8 (location of heart beats in last 30 secs of signal)
% & decision * 8

% 1. ECG-1 (gqrs)
beat_loc = [];  
if ( quaS(1) == 1 )
	channel_ = channel(1);	display(['Signal used: ECG-1 (' description{channel_} ') (gqrs)'])
    gqrs(recordName, Nend, Nstart, channel_, threshold);	% gqrs generate annotation file
    try
        [rr_, tm_] = ann2rr(recordName, 'qrs');
        beat_loc = tm_;	beat_loc(end+1, 1) = tm_(end, 1) + rr_(end, 1);
        clear rr_ tm_
    catch
        display(['Error (gqrs + ann2rr) in record: ' recordName ' signal: ECG-1 (' description{channel_} ')'])
    end
    delete([recordName '.qrs'])	% remove qrs annotation file
    alarmResult = 1; ecg_ind = 1;	% make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(1) = alarmResult;    % update decision output    
else
    results(1) = NaN; display('Skipped signal: ECG-1 (gqrs)')    % update decision output   
end

% 2. ECG-2 (gqrs)
beat_loc = [];	
if ( quaS(2) == 1 )
	channel_ = channel(2);	display(['Signal used: ECG-2 (' description{channel_} ') (gqrs)'])
    gqrs(recordName, Nend, Nstart, channel_, threshold);	% gqrs generate annotation file
    try
        [rr_, tm_] = ann2rr(recordName, 'qrs');
        beat_loc = tm_;	beat_loc(end+1, 1) = tm_(end, 1) + rr_(end, 1);
        clear rr_ tm_
    catch
        display(['Error (gqrs + ann2rr) in record: ' recordName ' signal: ECG-1 (' description{channel_} ')'])
    end
    delete([recordName '.qrs'])	% remove qrs annotation file
    alarmResult = 1; ecg_ind = 2;    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(2) = alarmResult;    % update decision output 
else
    results(2) = NaN; display('Skipped signal: ECG-2 (gqrs)')    % update decision output  
end

% 3. ABP (wabp)
beat_loc = [];
if ( quaS(3) == 1 )
	channel_ = channel(3);	display(['Signal used: ' description{channel_} ' (wabp)'])
	wabp(recordName, timeB{1}, timeS{1}, 1, channel_)	% wabp generate annotation file
    try
        [rr_, tm_] = ann2rr(recordName, 'wabp');
        beat_loc = tm_;	beat_loc(end+1, 1) = tm_(end, 1) + rr_(end, 1);
        clear rr_ tm_
    catch
        display(['Error (wabp + ann2rr) in record: ' recordName ' signal: ' description{channel_}])
    end
    delete([recordName '.wabp'])	% remove qrs annotation file
    alarmResult = 1; ecg_ind = [];    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(3) = alarmResult;    % update decision output 
else
    results(3) = NaN; display('Skipped signal: ABP (wabp)')    % update decision output  
end       

% 4. PLETH (wabp)
beat_loc = [];
if ( quaS(4) == 1 )
	channel_ = channel(4);	display(['Signal used: ' description{channel_} ' (wabp)'])
	wabp(recordName, timeB{1}, timeS{1}, 1, channel_)	% wabp generate annotation file
    try
        [rr_, tm_] = ann2rr(recordName, 'wabp');
        beat_loc = tm_;	beat_loc(end+1, 1) = tm_(end, 1) + rr_(end, 1);
        clear rr_ tm_
    catch
        display(['Error (wabp + ann2rr) in record: ' recordName ' signal: ' description{channel_}])
    end
    delete([recordName '.wabp'])	% remove qrs annotation file
    alarmResult = 1; ecg_ind = [];    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(4) = alarmResult;    % update decision output 
else
    results(4) = NaN; display('Skipped signal: PLETH (wabp)')    % update decision output  
end          
  
% 5. ECG-1 & ABP      (ann_signal_v4)
beat_loc = [];
if ( quaS(5) == 1 )
    channel_ecg = channel(1);	channel_bp = channel(3);	bp_ind = 1;	display(['Signal used: ECG-1 (' description{channel_ecg} ') + ' description{channel_bp}  ' (ann_signal_v4)'])
    beat_loc = ann_signal_v4(recordName, Nend, Nstart, channel_ecg, bp_ind, channel_bp, signal, Fs, threshold);
    alarmResult = 1; ecg_ind = 1;    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(5) = alarmResult;    % update decision output 
else
    results(5) = NaN; display('Skipped signal: ECG-1 + ABP (ann_signal_v4)')    % update decision output  
end       
    
% 6. ECG-1 & PLETH    (ann_signal_v4)
beat_loc = [];
if ( quaS(6) == 1 )
    channel_ecg = channel(1);	channel_bp = channel(4);	bp_ind = 2;	display(['Signal used: ECG-1 (' description{channel_ecg} ') + ' description{channel_bp}  ' (ann_signal_v4)'])
    beat_loc = ann_signal_v4(recordName, Nend, Nstart, channel_ecg, bp_ind, channel_bp, signal, Fs, threshold);
    alarmResult = 1; ecg_ind = 1;    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(6) = alarmResult;    % update decision output 
else
    results(6) = NaN; display(['Skipped signal: ECG-1 + PLETH (ann_signal_v4)'])    % update decision output  
end   
  
% 7. ECG-2 & ABP      (ann_signal_v4)
beat_loc = [];
if ( quaS(7) == 1 )
    channel_ecg = channel(2);	channel_bp = channel(3);	bp_ind = 1;	display(['Signal used: ECG-2 (' description{channel_ecg} ') + ' description{channel_bp}  ' (ann_signal_v4)'])
    beat_loc = ann_signal_v4(recordName, Nend, Nstart, channel_ecg, bp_ind, channel_bp, signal, Fs, threshold);
    alarmResult = 1; ecg_ind = 2;    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(7) = alarmResult;    % update decision output 
else
    results(7) = NaN; display('Skipped signal: ECG-2 + ABP (ann_signal_v4)')    % update decision output  
end 

% 8. ECG-2 & PLETH    (ann_signal_v4)
beat_loc = [];
if ( quaS(8) == 1 )
    channel_ecg = channel(2);	channel_bp = channel(4);	bp_ind = 2;	display(['Signal used: ECG-2 (' description{channel_ecg} ') + ' description{channel_bp}  ' (ann_signal_v4)'])
    beat_loc = ann_signal_v4(recordName, Nend, Nstart, channel_ecg, bp_ind, channel_bp, signal, Fs, threshold);
    alarmResult = 1;  ecg_ind = 2;    % make decision
    if(~isempty(beat_loc))
        alarmResult = fcheck_v5(recordName, beat_loc, alarmResult, alarm_type, Fs, Nend, signal, ecg_ind);
    end
    results(8) = alarmResult;    % update decision output 
else
    results(8) = NaN; display('Skipped signal: ECG-2 + PLETH (ann_signal_v4)')    % update decision output  
end   



% final alarm decision
alarmResult = 1;
if (sum(isfinite(results)) > 0)
    if ( sum(results == 0) / sum(isfinite(results)) >= thres2 )
        alarmResult = 0;
    end
end


display([recordName ' OK!'])    %(TO BE DISABLE)


% Write result to answers.txt
fid = fopen(answers, 'a');
if (fid == -1)
    error('Could not open answer file');
end

% Get base name of record (without directories)
i = strfind(recordName, filesep);
if (~isempty(i))
    basename = recordName(i(end)+1 : end);
else
    basename = recordName;
end

fprintf(fid, '%s,%d\n', basename, alarmResult);
fclose(fid);







%%%%%%%%%%%%%%%%%
% helper function to search signal (if good)
function ind = get_index(description, quaC, pattern)
M = length(description);
ind = [];
for m = 1:M
	if ( strmatch(description{m}, pattern, 'exact') & quaC(m) == 1 )
	ind(end+1) = m;
	end
end
























