% Matlab version of Yang Bo CinC challenge code
% Modification of 2014 challenge code for the 2015 challenge
%
% Version 4: using wabp (WFDB) for both ABP & PLETH  (created 05/08/2015)
% Version 2: to solve "error: A(I,J): row index out of bounds; value 1 out of bound 0"
% The "warning: division by zero" could be caused by empty var [delay] 
% In ============ Predicting the noisy part of qrs with BP-QRS delay (Start) ============
% added_peak = [];
% if ( bp_ind_flag &&  length(delay) && length(bp_peak) )	% added by JC to check existance of (1) delay (2) bp_peak
%
function prediction_final = ann_signal_v4(recordName,N,N0,ecg_ind,bp_ind,bp_index,signal,Fs,threshold)
% function input:
% N - ending index for anntotation
% N0 - starting index for annotation
% ecg_ind - scalar index for ECG channel
% bp_ind - scalar index for ABP or PLETH channel 
% bp_ind = [] if there are no ABP or PLETH channel
% bp_ind = 1 if there is ABP signal
% bp_ind = 2 if there is PLETH channel (using the modified WABP for annotating PLETH)
% bp_index - integer index for specifying the channel # of the ABP or PLETH in the signal variable
% signal - matrix storing the values for the different channels
% Fs - sampling frequency

% Octave-compatible code for the 2014 PhysioNet/CinC Challenge
% annotation for ECG signal
annName = 'qrs'; 

% converts sample index to WFDB Time; added by JC (05/08/2015)
[timeB, dateB] = wfdbtime(recordName, N0);		
[timeS, dateS] = wfdbtime(recordName, N);

% ============ data acquisition (Start) ============
% checking if there is BP signal
if(size(bp_ind,1)==0)
    bp_ind_flag = false;
else
    bp_ind_flag = true;
end

% defining the threshold for the gqrs annotation algorithm
%threshold = [];
%threshold = 2.0 * .7;
gqrs(recordName,N,N0,ecg_ind,threshold,annName);
% qrs_peak = rdann(recordName,annName);
%[rr_ecg,tm_ecg] = ann2rr(recordName,annName);
try
    [rr_ecg,tm_ecg] = ann2rr(recordName,annName);
catch
    rr_ecg = NaN;
    tm_ecg = NaN;
    display(['Error in: ' recordName ' signal ' mat2str(ecg_ind) ' (gqrs)'])	% try_catch command added by JC
end
delete([recordName '.qrs'])	% added by JC to delete gqrs annotation file
tm_ecg(end+1,1) = tm_ecg(end,1)+rr_ecg(end,1);
qrs_peak = tm_ecg+1;
% fprintf('End of gqrs\n');toc

% ann procedure modified by JC (05/08/2015)
% using wabp (WFDB) for both ABP & PLETH
if(bp_ind_flag)
    wabp(recordName, timeB{1}, timeS{1}, 1, bp_index)
    try
        [rr_abp,tm_abp] = ann2rr(recordName,'wabp');
    catch
        rr_abp = NaN;
        tm_abp = NaN;
        display(['Error in: ' recordName ' signal ' mat2str(bp_index) ' (wabp)'])	% try_catch command added by JC
    end
    delete([recordName '.wabp'])	% added by JC to delete wabp annotation file 
    tm_abp(end+1,1) = tm_abp(end,1)+rr_abp(end,1);
    bp_peak = [];
    for i=1:size(tm_abp)
        if (tm_abp(i,1) > N0 && tm_abp(i,1) < N)
            bp_peak = [bp_peak;tm_abp(i,1)];
        end
    end
    bp = signal(:,bp_index);
end
% fprintf('End of wabp\n');toc

% SK: There is no need to normalize the ecg signal by the gain. Matlab function seems to do it automatically
ecg = signal(:,ecg_ind);

% Getting the sampling frequency of the data-set
sampfreq = Fs; 
margin = 0.15*sampfreq;

% ============ data acquisition (End) ============
% fprintf('End of data acquisition\n'); toc

% ============ raw data processing (Start) ============

% if BP signal is present, the gqrs signal is pruned.
pholder=[]; peak_cluster = cell(0,1); peak_cluster_counter = 1;
delay = []; delay_index = cell(0,1); delay_index_counter = 1;
n_bp = [];

if(bp_ind_flag)

    count = 1;
    
    for i=1:( size(bp_peak,1)-1 )
        for j=count:size(qrs_peak,1)
            
            % searching for all qrs peak in-between BP peak i and i+1
            if( qrs_peak(j,1)>=bp_peak(i,1) && qrs_peak(j,1)<=bp_peak(i+1,1) )
                pholder = [pholder;j];
            end
            
            if( qrs_peak(j,1) > bp_peak(i+1,1) )
                count = j; break;
            end
            
        end  % end of for j=count:size(qrs_peak,1)
        
        peak_cluster{peak_cluster_counter,1} = pholder; 
        peak_cluster_counter = peak_cluster_counter + 1;
        
        if(size(pholder,1)==1)
            
            delay = [delay; bp_peak(i+1,1) - qrs_peak(pholder(1),1) ];
            delay_index{delay_index_counter,1} = [i+1; pholder(1)];
            delay_index_counter = delay_index_counter + 1;
            
        else % size(pholder,1) != 1
            
            for m=1:size(pholder,1)
                
                qrs_peak(pholder(m,1),1) = -qrs_peak(pholder(m,1),1); % the noisy part of qrs_peak
                
            end % end of for m=1:size(pholder,1) loop
            
            n_bp = [n_bp; bp_peak(i+1,1) ];
            
        end % end of if(size(pholder,1)==1) loop
        
        pholder=[];
                
    end  % end of for i=1:( size(bp_peak,1)-1 ) loop
   
end  % end of if(bp_ind_flag) loop

% fprintf('End of pholder and delay loop\n'); toc

% get the qrs peak intervals from the clean part of qrs_peak
gqrs_interval =[]; gqrs_interval_index =[];

for i=1:( size(qrs_peak,1)-1 )
    if( qrs_peak(i+1,1)>0 && qrs_peak(i,1)>0 )
        % computing the qrs interval between peak i and i+1
        gqrs_interval = [gqrs_interval;qrs_peak(i+1,1)-qrs_peak(i,1)];
        gqrs_interval_index = [gqrs_interval_index;i];
    end
end % end of for i=1:size(qrs_peak,1) loop

% get the mean interval from gqrs
gqrs_mean = mean(gqrs_interval);

% get the moving mean interval from gqrs
% the moving mean is calculated five peaks before and after the current peak
m_gqrs_mean = moving_mean(gqrs_interval,5);

% get the mean value of the ecg signal
ecg_average=mean(ecg);

% get the moving mean value of the ecg signal
% the moving mean is calculated 50 data points before and after the current data point
% m_ecg_average = moving_mean(ecg,50);

% fprintf('End of moving average for ecg\n'); toc

if(bp_ind_flag)
    
    % get the mean value of the bp signal
    bp_average=mean(bp);
    
    % get the moving mean value of the bp signal
    % the moving mean is calculated 1500 data points before and after the current data point
    % m_bp_average = moving_mean(bp,1500);
    
end

% fprintf('End of moving average for bp\n'); toc

% get the mean value of the qrs peak signal
qrs_peak_s = []; qrs_peak_s_index=[]; % the noisy part of qrs_peak is not included
for i=1:size(qrs_peak,1)
    if( qrs_peak(i,1) > 0 )
        first = floor(qrs_peak(i,1)-3*margin);
        last = ceil(qrs_peak(i,1)+3*margin);
        
        % checking for array-out-of-bound
        if( last > size(ecg,1) )
            last = size(ecg,1);
        end
        
        if( first < 1 )
            first = 1;
        end   

        newVec = ecg(first:last,1);
        qrs_peak_s = [qrs_peak_s;max(newVec)];
        qrs_peak_s_index = [qrs_peak_s_index;i];
    end
end % end of for i=1:size(qrs_peak,1) loop

qrs_peak_average = mean(qrs_peak_s);

% fprintf('End of mean value of the qrs peak signal\n'); toc

% get the moving mean value of the qrs peak signal
% the moving mean is calculated five peaks before and after the current peak
m_qrs_peak_average = moving_mean(qrs_peak_s,5);

if(bp_ind_flag)

    % check the integraty of bp_peak
    % get the mean and standard deviation of the intervals between bp peaks
    bp_peak_interval = zeros(size(bp_peak,1)-1,1); 
    
    for i=1:( size(bp_peak,1)-1 )
        bp_peak_interval(i,1) = bp_peak(i+1,1)-bp_peak(i);
    end  % end of for i=1:( size(bp_peak,1)-1 ) loop
    
    bpmean = mean(bp_peak_interval); bpsd = std(bp_peak_interval);
    
    % get the moving mean interval between bp peaks
    % the moving mean is calculated ten peaks before and after the current peak
    m_bp_interval_mean=moving_mean(bp_peak_interval,50);
    
    % use the moving mean interval, check for abnormal intervals
    allowance=0.6;
    
    for i=1:size(bp_peak_interval,1)
        if((allowance*bp_peak_interval(i,1)-m_bp_interval_mean(i,1))>0)
            
            % this bp interval is too big, one or more bp signal could be missing
            % trying to capture S and V peaks
            if (size(peak_cluster{i,1},1)==2)
                % subroutine function to scan for S and V peaks (15Aug14)
                qrs_peak = scheck(peak_cluster{i,1}(1),qrs_peak,ecg,margin);
                qrs_peak = scheck(peak_cluster{i,1}(2),qrs_peak,ecg,margin);
                
            elseif(size(peak_cluster{i,1},1)>2)  
                
                % more than two qrs peaks sandwiched between the two bp peaks
                for j=1:size(gqrs_interval_index,1)
                    if(gqrs_interval_index(j,1)>peak_cluster{i,1}(1))
                        
                        % SK (modification - 26th March 15)
                        if(j==1)
                            average=m_gqrs_mean(j,1);
                        else
                            average=(m_gqrs_mean(j-1,1)+m_gqrs_mean(j,1))/2.0;
                        end
                        check = true;
                        for k=1:( size(peak_cluster{i,1},1)-1 )
                            if ( abs(-qrs_peak(peak_cluster{i,1}(k+1),1) + qrs_peak(peak_cluster{i,1}(k),1) - average) > margin )
                                check = false;
                            end  % end of if ( abs(-qrs_peak(peak_cluster{i,1}(k+1),1) + qrs_peak(peak_cluster{i,1}(k),1) - average) > margin ) loop
                        end  % end of for k=1:( size(peak_cluster{i,1},1)-1 ) loop
                        
                        % all sandwiched qrs peaks are reasonably spaced
                        if (check)
                            for k=1:size(peak_cluster{i,1},1)
                                qrs_peak(peak_cluster{i,1}(k),1) = -qrs_peak(peak_cluster{i,1}(k),1);
                            end  % end of for k=1:size(peak_cluster{i,1},1) loop
                        end  % end of if (Check) loop
                        
                        % here we reidentify part of noisy qrs_peak as clean, because of missing bp peaks in the signal
                        break;
                        
                    end  % end of if(gqrs_interval_index(j,1)>peak_cluster{i,1}(1)) loop
                    
                end  % end of for j=1:size(gqrs_interval_index,1) loop
                
            end  % end of if (size(peak_cluster{i,1},1)~=1)
            
        end  % end of if((allowance*bp_peak_interval(i,1)-m_bp_interval_mean(i,1))>0) loop
        
        % this is the case when bp interval is too big, and there are more than one qrs peaks sandwiched
        
    end  % end of for i=1:size(bp_peak_interval,1) loop
    
    for i=1:size(bp_peak_interval,1)
        if (((allowance*m_bp_interval_mean(i,1)>bp_peak_interval(i,1))>0) && bp_peak(i,1)>0)
            % this bp interval is too small
            
            if ( size(peak_cluster{i,1},1) ==0 )
                % there is no qrs peak sandwiched
                bp_peak(i+1,1)= -bp_peak(i+1,1); % the bp peak is labeled as negative
            else
                % it could still be the qrs part is noisy
                index1 = locatemax(bp,bp_peak(i,1),ceil(margin));
                index2 = locatemax(bp,bp_peak(i+1,1),ceil(margin));
                s1=bp(index1,1); s2=bp(index2,1);

                % computing the m_bp_average on the fly using a moving average window size of 3000
                bp_window_size=3000; m_bp_average_index_temp = 0;
                for temp_i=1:2
                    if(temp_i==1)
                        bp_index_temp = bp_peak(i,1);
                    else
                        bp_index_temp = bp_peak(i+1,1);
                    end
                    
                    if(bp_index_temp <= bp_window_size)
                        % for the first nth points
                        m_bp_average_index_temp = mean( bp(1:2*bp_window_size+1,1) );
                    elseif( bp_index_temp > bp_window_size && bp_index_temp <= (size(bp,1)-bp_window_size))
                        m_bp_average_index_temp = mean ( bp(bp_index_temp-bp_window_size:bp_index_temp+bp_window_size,1) );
                    elseif( bp_index_temp > (size(bp,1)-bp_window_size) )
                        m_bp_average_index_temp =  mean ( bp(size(bp,1)-(2*bp_window_size):size(bp,1),1) );
                    end
                                        
                    if(temp_i==1)
                        m_bp_average_index1 = m_bp_average_index_temp;
                    else
                        m_bp_average_index2 = m_bp_average_index_temp;
                    end                                      
                end % end of for temp_i=1:2
                s1=s1-m_bp_average_index1; s2=s2-m_bp_average_index2;
                % s1=s1-m_bp_average(bp_peak(i,1),1); s2=s2-m_bp_average(bp_peak(i+1,1),1);
                
                if( abs(s1/s2)>1.1 || abs(s1/s2)<0.9 )
                    % the two consecutive bp peak values differ by to much, or they are too close and within the margin, we assume the bp is noisy here
                    if (s1>s2 && bp_peak(i+1,1)>0)
                        bp_peak(i+1,1) = -bp_peak(i+1,1);
                    end
                    if (s1<s2 && bp_peak(i,1)>0)
                        bp_peak(i,1) = -bp_peak(i,1);
                    end
                end  % end of if( abs(s1/s2)>1.1 | abs(s1/s2)<0.9 ) loop
                
                % label all the corresponding qrs peak as noisy
                for j=1:size(peak_cluster{i,1},1)
                    qrs_peak(peak_cluster{i,1}(j),1) = -qrs_peak(peak_cluster{i,1}(j),1);
                end
                
                % add the leading bp peak
                if ( bp_peak(i+1,1)>0 )
                    n_bp = [n_bp; bp_peak(i+1,1) ];
                end
                
            end  % end of if ( size(peak_cluster{i,1},1) ==0 ) loop
            
        end  % end of if (((allowance*m_bp_interval_mean(i,1)>bp_peak_interval(i,1))>0) & bp_peak(i,1)>0)) loop
        
    end  % end of for i=1:size(bp_peak_interval,1) loop
    
    % sorting n_bp
    n_bp = sort(n_bp);

    % basically, if the two bp signals are two far apart, the previously identified noisy qrs signals in between may be reidentified as clean
    % if the two bp signals are too close, the second one is identified as noise if they do not sandwich any qrs peaks.
    % we also assume here if there is a real qrs peak, gqrs may not miss it, though gqrs may have false positive.
    
    % however, it is observed that gqrs does miss real qrs peak. the case where gqrs miss the first and the last peak will be taken care of later.
    % one can be sure that gqrs misses a peak if the bp interval is neither too big, nor too small, but there is no qrs peak sandwiched in between. this case
    % will also be taken care of later.
    
end  % end of if(bp_ind_flag) loop

% ============ raw data processing (End) ============
% fprintf('End of raw data processing\n'); toc

% ============ Predicting the noisy part of qrs with BP-QRS delay (Start) ============
added_peak = [];
if ( bp_ind_flag && length(delay) && length(bp_peak) )	% added by JC to check existance of (1) delay (2) bp_peak
    
    % get the mean BP-QRS delay
    delay_mean = mean(delay);
    % get the moving mean of BP-QRS delay
    m_delay_mean = moving_mean(delay,10);
    
    % use the moving mean to find the qrs peak for the noisy part of qrs peak signal
    i=1;
    while ( i < size(qrs_peak,1) )
        if ( qrs_peak(i,1)<0 )
            leadingbp=-1;
            
            for j=1:size(n_bp,1)
                if( abs(n_bp(j,1)) > abs(qrs_peak(i,1)) )
                    leadingbp=n_bp(j,1);
                    break;
                end
            end  % end of for j=1:size(n_bp,1) loop
            
            if ( leadingbp < 0 )
                i=i+1;
                continue;
            end
            
            flag = false;
            for j=1:size(qrs_peak,1)
                for k=1:size(delay_index,1)
                    
                    if( delay_index{k,1}(2)==i-j )
                        
                        % Debug
                        % fprintf('delay_index = %d and i = %d and j = %d and k = %d\n',delay_index{k,1}(2),i,j,k);
                        
                        % find the nearest clean part of qrs peak before the noisy qrs peak
                        flag = true;
                        % find the average moving delay mean before and after the noisy part
                        % SK (modification - 26th March 15)
                        % checking that k is not greater than size of m_delay_mean
                        if( k>=size(m_delay_mean,1) )
                            average = m_delay_mean(end,1);
                        else
                            average = ( m_delay_mean(k,1) + m_delay_mean(k+1,1) )/ 2;
                        end
                        count = [];
                        
                        index_i = i;
                        for m=0:size(qrs_peak,1)-1
                            
                            % SK (modification - 26th March 15)
                            % checking that (i+m) is not greater than size of qrs_peak
                            if( (i+m) > size(qrs_peak,1) )
                                break;
                            else
                                
                                if ( qrs_peak(i+m,1) > 0 || abs(qrs_peak(i+m,1)) > leadingbp )
                                    i=i+m-1;
                                    % Control logic flow error (06 June 2014)
                                    % the idea is to skip to the new i value in the outer i loop
                                    % Debug
                                    % fprintf('Value of i = %d and m = %d\n', i,m);
                                    
                                    break;
                                end
                            end
                            
                            % Debug:
                            % if(i+m==682)
                            %    fprintf('leadingbp = %d , qrs_peak = %d, average = %f \n',leadingbp, qrs_peak(i+m,1), average);
                            % end
                            
                            % find a qrs peak in the noisy part that precedes the associated bp peak by the proper amount
                            if ( abs(leadingbp + qrs_peak(i+m,1) - average) < margin )
                                                               
                                count = [count; m];
                                qrs_peak(i+m,1) = -qrs_peak(i+m,1);
                            end
                            
                        end  % end of for m=1:size(qrs_peak,1) loop
                        
                        % no qrs peak was found preceding a proper bp signal
                        if ( size(count,1) == 0 )
                            % gqrs have missed a peak (we assume the bp part is clean). this peak is added
                            added_peak  = [added_peak; round(leadingbp-average)];
                            
                            % Debug
                            % fprintf('Added peak at size(count,1) == 0 \n');
                            
                        elseif ( size(count,1) > 1 )
                            % more than one noisy qrs peaks are clustered together
                            index_average=0;
                            for n=1:size(count,1)
                                index_average = index_average - qrs_peak(index_i+count(n,1),1);
                                % relabel those part as noisy (06 June 2014)
                                % qrs_peak(i+count(n,1),1) = -qrs_peak(i+count(n,1),1);
                            end
                            
                            index_average = index_average/size(count,1);
                            % the average position of those noisy clusters are identified as the proper position of the qrs peak
                            added_peak = [added_peak; round(index_average)];
                            
                            % Debug
                            % fprintf('Added peak at size(count,1) > 1 \n');
                            
                        end  % end of if ( size(count,1) == 0 ) loop
                        
                        count = [];
                        
                    end  % end of if( delay_index{k,1}(1)==i-j ) loop
                    
                    if ( flag )
                        break;
                    end
                    
                end  % end of for k=1:size(delay_index,1) loop
                
                if ( flag )
                    break;
                end
                
            end  % end of for j=1:size(qrs_peak,1) loop
            
        end  % end of if ( qrs_peak(i,1)<0 ) loop
        
        % increasing the value of i by 1
        i=i+1;
        
    end  % end of while ( i < size(qrs_peak,1) ) loop
    
    % check for the first peak
    s = floor( bp_peak(1,1) - m_delay_mean(1,1) - margin );
    e = floor( bp_peak(1,1) - delay(1,1) + margin );
    
    if (s<1)
        s=1;
    end
    if ( e+1 > size(ecg,1) )
        e = size(ecg,1)-1;
    end
    
    max_ecg=ecg(s,1); index=s;
    
    for i=s:e+1
        if( ecg(i,1) > max_ecg )
            max_ecg = ecg(i,1); index = i;
        end
    end  % end of for i=s:e+1 loop
    
    % computing the m_ecg_average(index,1) on the fly using a moving average window size of 100
    ecg_window_size=100; m_ecg_average_index = 0;
    if(index <= ecg_window_size)
        % for the first nth points
        m_ecg_average_index = mean( ecg(1:2*ecg_window_size+1,1) );
    elseif( index > ecg_window_size && index <= (size(ecg,1)-ecg_window_size))
        m_ecg_average_index = mean ( ecg(index-ecg_window_size:index+ecg_window_size,1) );
    elseif( index > (size(ecg,1)-ecg_window_size) )
        m_ecg_average_index =  mean ( ecg(size(ecg,1)-(2*ecg_window_size):size(ecg,1),1) );
    end

    if ( (max_ecg-m_ecg_average_index) > ( m_qrs_peak_average(1,1) - m_ecg_average_index )/2 )
        if ( abs( qrs_peak(1,1)-index ) > margin )
            qrs_peak = [qrs_peak; index];
        end
    end  % end of if ( (max-m_ecg_average(index,1)) > ( m_qrs_peak_average(1,1) - m_ecg_average(index,1) )/2 ) loop
    
    % check for the last peak
    % SK (modification - 30th March 15)    
    s = bp_peak(size(bp_peak,1),1); temp_index = size(bp_peak,1);
    while(s<0)
        temp_index = temp_index-1;
        s = bp_peak(temp_index,1);
    end
    max_ecg=ecg(s,1); index=s;
    
    for i=s:size(ecg,1)
        if ( ecg(i,1) > max_ecg )
            max_ecg = ecg(i,1); index = i;
        end
    end  % end of for i=s:size(ecg,1) loop

    % computing the m_ecg_average(index,1) on the fly using a moving average window size of 100
    ecg_window_size=100; m_ecg_average_index = 0;
    if(index <= ecg_window_size)
        % for the first nth points
        m_ecg_average_index = mean( ecg(1:2*ecg_window_size+1,1) );
    elseif( index > ecg_window_size && index <= (size(ecg,1)-ecg_window_size))
        m_ecg_average_index = mean ( ecg(index-ecg_window_size:index+ecg_window_size,1) );
    elseif( index > (size(ecg,1)-ecg_window_size) )
        m_ecg_average_index =  mean ( ecg(size(ecg,1)-(2*ecg_window_size):size(ecg,1),1) );
    end
    
    if ( (max_ecg-m_ecg_average_index) > ( m_qrs_peak_average(size(m_qrs_peak_average,1),1)-m_ecg_average_index )/2 )
        if ( abs( qrs_peak(size(qrs_peak,1),1) - index ) > margin )
            qrs_peak = [qrs_peak; index];
        end
    end
    
end  % end of if(bp_ind_flag) loop

% gqrs also tends to misidentify the first and last peak
% check for the last qrs peak
if ( qrs_peak(end,1) > 0 )
    s = floor( qrs_peak(end,1)-margin );
    e = ceil( qrs_peak(end,1)+margin );
    if ( e > size(ecg,1) )
        e = size(ecg,1);
    end
    if ( s < 1 )
        s = 1;
    end
    
    max_ecg=ecg(s,1); index = s;
    for i=s:e
        if ( ecg(i,1) > max_ecg )
            max_ecg = ecg(i,1); index = i;
        end
    end  % end of for i=s:e loop

    % computing the m_ecg_average(index,1) on the fly using a moving average window size of 100
    ecg_window_size=100; m_ecg_average_index = 0;
    if(index <= ecg_window_size)
        % for the first nth points
        m_ecg_average_index = mean( ecg(1:2*ecg_window_size+1,1) );
    elseif( index > ecg_window_size && index <= (size(ecg,1)-ecg_window_size))
        m_ecg_average_index = mean ( ecg(index-ecg_window_size:index+ecg_window_size,1) );
    elseif( index > (size(ecg,1)-ecg_window_size) )
        m_ecg_average_index =  mean ( ecg(size(ecg,1)-(2*ecg_window_size):size(ecg,1),1) );
    end
    
    if ( (max_ecg - m_ecg_average_index) < (m_qrs_peak_average(end,1)-m_ecg_average_index)/2 )
        qrs_peak(end) = [];
    end
    
end  % end of if ( qrs_peak(end,1) > 0 ) loop

% ============ Predicting the noisy part of qrs with BP-QRS delay (End) ============
% fprintf('End of Predicting the noisy part of qrs\n'); toc

% ============ Taking care of the case where gqrs misses a potential peak (Start) ============

% if the bp interval is neither too big, nor too small, but there is no qrs peak sandwiched in between, we need to check if the gqrs misses a peak
if(bp_ind_flag)
    
    for i=1:size(bp_peak_interval,1)
        if ( abs(m_bp_interval_mean(i,1)-bp_peak_interval(i,1)) < margin && bp_peak(i,1)>0 && bp_peak(i+1,1)>0 )
            % this bp interval is normal as compared to its surroundings
            if ( size(peak_cluster{i,1},1)==0 )
                % there is no qrs peak sandwiched
                index1=locatemax(bp,bp_peak(i,1),ceil(margin));
                index2=locatemax(bp,bp_peak(i+1,1),ceil(margin));

                % computing the m_bp_average on the fly using a moving average window size of 3000
                bp_window_size=3000; m_bp_average_index_temp = 0;
                for temp_i=1:2
                    if(temp_i==1)
                        bp_index_temp = bp_peak(i,1);
                    else
                        bp_index_temp = bp_peak(i+1,1);
                    end
                    
                    if(bp_index_temp <= bp_window_size)
                        % for the first nth points
                        m_bp_average_index_temp = mean( bp(1:2*bp_window_size+1,1) );
                    elseif( bp_index_temp > bp_window_size && bp_index_temp <= (size(bp,1)-bp_window_size))
                        m_bp_average_index_temp = mean ( bp(bp_index_temp-bp_window_size:bp_index_temp+bp_window_size,1) );
                    elseif( bp_index_temp > (size(bp,1)-bp_window_size) )
                        m_bp_average_index_temp =  mean ( bp(size(bp,1)-(2*bp_window_size):size(bp,1),1) );
                    end
                                        
                    if(temp_i==1)
                        m_bp_average_index1 = m_bp_average_index_temp;
                    else
                        m_bp_average_index2 = m_bp_average_index_temp;
                    end                                      
                end % end of for temp_i=1:2

                s1=bp(index1,1) - m_bp_average_index1;
                s2=bp(index2,1) - m_bp_average_index2;

                % s1=bp(index1,1) - m_bp_average(bp_peak(i,1),1);
                % s2=bp(index2,1) - m_bp_average(bp_peak(i+1,1),1);
                
                if ( abs(s1/s2)<1.1 && abs(s1/s2)>0.9 )
                    % if the two consecutive bp peak values do not differ by to much, we assume the bp is not noisy here
                    for j=1:size(delay_index,1)
                        if ( bp_peak(delay_index{j,1}(1),1) > bp_peak(i,1) )
                            % SK (modification - 26th March 15)
                            if(j==1)
                                average = m_delay_mean(j,1);
                            else
                                average = ( m_delay_mean(j-1,1) + m_delay_mean(j,1) )/2;
                            end
                            qrs_peak = [qrs_peak ; bp_peak(i+1,1)-average];
                            break;
                        end  % end of if ( bp_peak(delay_index{j,1}(1),1) > bp_peak(i,1) )
                        
                    end  % end of for j=1:size(delay_index,1) loop
                    
                end  % end of if ( abs(s1/s2)<1.1 & abs(s1/s2)>0.9 ) loop
                
            end  % end of if ( size(peak_cluster{i,1},1)==0 ) loop
            
        end  % end of if ( abs(m_bp_interval_mean(i,1)-bp_peak_interval(i,1)) < margin & bp_peak(i,1)>0 & bp_peak(i+1,1)>0 ) loop
        
    end  % end of for i=1:size(bp_peak_interval,1) loop
    
    % sorting qrs_peak
    qrs_peak = sort(qrs_peak);
    
end  % end of if(bp_ind_flag) loop

% ============ Taking care of the case where gqrs misses a potential peak (End) ============
% fprintf('End of Taking care of the case where gqrs misses\n'); toc

% ============ Making predictions (Start) ============
prediction = [];
for i=1:size(qrs_peak,1)
    if ( qrs_peak(i,1) > 0 )
        prediction = [prediction; qrs_peak(i,1)];
    end
end  % end of for i=1:size(qrs_peak,1) loop

for i=1:size(added_peak,1)
    prediction = [prediction; added_peak(i,1)];
end

% sorting prediction
prediction_sort = sort(prediction);
% fprintf('End of sorting predictions\n'); toc

% adding in 1 additional layer of check to ensure no 2 consecutive qrs peaks are within 2*margins
qrs_interval_vect = zeros(size(prediction_sort,1)-1,1);
for i=1:size(prediction_sort,1)-1
    delta_interval = prediction_sort(i+1,1)-prediction_sort(i,1);
    if(delta_interval < 2*margin)
        qrs_interval_vect(i,1) = 1;
    end
end

prediction_mod1 = prediction_sort;
for i=1:size(qrs_interval_vect,1)
    % interval smaller than 2 * margins
    if(i <= size(qrs_interval_vect,1) - 3)
        if(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1)) / 2);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 && qrs_interval_vect(i+2)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1)) / 3);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 && qrs_interval_vect(i+2)==1 && qrs_interval_vect(i+3,1)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1) + prediction_sort(i+3,1)) / 4);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
            prediction_mod1(i+3,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 && qrs_interval_vect(i+2)==1 && qrs_interval_vect(i+3,1)==1)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1) + prediction_sort(i+3,1) + prediction_sort(i+4,1)) / 5);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
            prediction_mod1(i+3,1) = temp_v;
            prediction_mod1(i+4,1) = temp_v;
        end
    elseif( i == size(qrs_interval_vect,1) - 2 )
        if(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1)) / 2);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 && qrs_interval_vect(i+2)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1)) / 3);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 && qrs_interval_vect(i+2)==1)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1) + prediction_sort(i+3,1)) / 4);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
            prediction_mod1(i+3,1) = temp_v;
        end
    elseif( i == size(qrs_interval_vect,1) - 1 )
        if(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==0)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1)) / 2);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
        elseif(qrs_interval_vect(i,1)==1 && qrs_interval_vect(i+1)==1 )
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1) + prediction_sort(i+2,1)) / 3);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
            prediction_mod1(i+2,1) = temp_v;
        end
    elseif( i == size(qrs_interval_vect,1) )
        if(qrs_interval_vect(i,1)==1)
            temp_v = round( (prediction_sort(i,1) + prediction_sort(i+1,1)) / 2);
            prediction_mod1(i,1) = temp_v;
            prediction_mod1(i+1,1) = temp_v;
        end     
    end
end

prediction_final = unique(prediction_mod1);

% writing the prediction into the qrs annotation file
% wrann(recordName,annName,prediction_final);
% fprintf('End of Making predictions\n'); toc

% ============ Making predictions (End) ============

%%%%%%%%%%%% Helper Function get_index %%%%%%%%%%%%%%%%%%%%%
% Inputs:
%   description  strings containing signal descriptions from wfdbdesc
%   pattern      a string to be found in the descriptions
% Output:
%   ind          indices of the descriptions that contain the pattern

function ind = get_index(description,pattern)
M = length(description);
tmp_ind = strfind(description,pattern);
ind = [];
for m = 1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1) = m;
    end
end

%%%%%%%%%%%% Helper Function moving_mean %%%%%%%%%%%%%%%%%%%%%
    function m_mean = moving_mean(array,n)
        N = size(array,1);
        m_mean = zeros(N,1);
		
        % SK (modification - 26th March 15)
        % checking that the size of array is greater than 2n + 1
		if(N >= 2*n+1)
            
            % for the first nth points
            temp1 = mean( array(1:2*n+1,1) );
            for i=1:n
                m_mean(i,1) = temp1;
            end
            
            % for the (n+1)th point to the (N-n)th point, where N = size(array,1)
            for i=(n+1):( N-n )
                m_mean(i,1) = mean ( array(i-n:i+n,1) );
            end
            
            % for the (N-n+1)th point to the Nth point
            temp2 = mean ( array(N-(2*n):N,1) );
            for i=(N-n+1): N
                m_mean(i,1) = temp2;
            end
            
        else
            % just return the mean of the array
            temp = mean(array);
            for i=1:N
                m_mean(i,1) = temp;
            end
        end
        
        % for debugging only
        %check = size(m_mean,1) - size(array,1);
        %if(check~=0)
        %    fprintf('*** [moving_mean]: Error in size of m_mean ***\n');
        %end
        
        %%%%%%%%%%%% Helper Function locatemax %%%%%%%%%%%%%%%%%%%%%
        function index = locatemax(source, center, p)
            
            % SK (modification - 26th March 15)
            if( (center - p) < 1)
                % Input parameters center and p must be integers
                max = source(1,1); index = 1;
                
                for i=1:2*p+1
                    temp_index = 1+i;
                    if( temp_index > size(source,1))
                        temp_index = size(source,1);
                    end
                    if( max < source(temp_index,1) )
                        max = source(temp_index,1);
                        index = temp_index;
                    end            
                end  % end of for i=1:2*p+1 loop
                
            else
                % Input parameters center and p must be integers
                max = source(center-p,1); index = center - p;
                
                for i=1:2*p+1
                    temp_index = center-p+i;
                    if(temp_index > size(source,1))
                        temp_index = size(source,1);
                    end
                    if( max < source(temp_index,1) )
                        max = source(temp_index,1);
                        index = temp_index;
                    end
                end  % end of for i=1:2*p+1 loop
            end
            
        %%%%%%%%%%%% Helper Function scheck %%%%%%%%%%%%%%%%%%%%%
        function qrs_peak = scheck(index,qrs_peak,ecg,margin);
            % for debugging
            % fprintf('Fucntion scheck: qrs_peak = %d at index %d\n',qrs_peak(index),index);
            % note all qrs_peak[index] here are negative
            s = floor(-qrs_peak(index) - 2*margin); e = ceil(-qrs_peak(index) + 2*margin);
            if ( s < 1 )
                s = 1;
            end
            if ( e > size(ecg,1) )
                e = size(ecg,1);
            end
            
            % vector containing the ecg signal from s to e
            s_ecg = ecg(s:e,1);
            % moving mean for s_ecg with a window size of 10
            m_ecg = moving_mean(s_ecg,10);
            % find the max and min values of m_ecg
            m_ecg_min = min(m_ecg); m_ecg_max = max(m_ecg);
            
            % line intersection
            stepsize=0.1; nstep=round((m_ecg_max-m_ecg_min)/stepsize);
            countmax=0;
            for i=1:nstep
                count=0;
                line=m_ecg_min+stepsize*i;
                for j=1:size(m_ecg,1)-1
                    if(m_ecg(j,1)<line && m_ecg(j+1,1)>line)
                        count = count+1;
                    end
                     if(m_ecg(j,1)>line && m_ecg(j+1,1)<line)
                        count = count+1;
                     end   
                end % end of for j=1:size(m_ecg,1)
                if(countmax<count)
                    countmax=count;
                end               
            end % end of for i=1:nstep
            
            if (countmax<6)
                qrs_peak(index) = -qrs_peak(index);
            end
                
            
            
