function Ind_extrema = find_extrema(x,M,thresh,s)

% local extrema of signal x
% M length pf the sliding window (must be odd), defines the distance
% between successive local extrema
% thresh number of times the point must be a local extremum. must be an
% integer around 2/3 of M
% s = 'min' or 'max'
% Ind_extrema indexes local extrema


N = length(x);
Ind = zeros(N,1);

for k=1:N+1-M,
    if s=='min',
    [bid,loc] = min(x(k:k+M-1));
    Ind(k+loc-1) = Ind(k+loc-1) + 1;
    end
    if s=='max',
    [bid,loc] = max(x(k:k+M-1));
    Ind(k+loc-1) = Ind(k+loc-1) + 1;
    end
end
Ind_extrema = find(Ind>thresh);

% figure
% plot(1:N,x,Ind_extrema,x(Ind_extrema),'*r')


   