function [PPGf, baseline] = filter_PPG(PPG,fs,fc,Baseline,Aff)
% Low pass butterworth (oder 8) filter for the pre-processing of the PPG
% signal
% PPG: data matrix (1 PPG channel / col)
% fs: sampling frequency of the PPG signal (Hz)
% fc: cutoff frequency for the filter (Hz)
% Baseline: si 1,baseline is removed using the envelops 

baseline = [];
n = size(PPG); n=n(2); 

if(fc>0) % Low pass filter 
Wn = [(fc/fs)*2];
[B,A] = butter(8,Wn,'low');
for i=1:n    
PPGf(:,i) = filtfilt(B,A,PPG(:,i)); 
end

else
PPGf = PPG;   
end

if(Baseline ==1) 
if(Aff ==1)
figure
end
for i=1:n
[es,ei,~,~] = envelopes(PPGf(:,i),round(1*fs));
baseline = (es+ei)/2;
[average, stdev] = Moving_Average(baseline,round(1.5*fs));
baseline = average;

if(Aff ==1)
ax(1) = subplot(211);
plot((1:length(PPGf(:,i)))/fs,PPGf(:,i));
hold on;
plot((1:length(baseline))/fs,baseline,'r'); title('PPG signal and baseline')
hold off;
ylabel('A.U.'); grid on;
end

PPGf(:,i) = PPGf(:,i)-baseline(:); 

if(Aff ==1)
 ax(2) = subplot(212);
plot((1:length(PPGf(:,i)))/fs,PPGf(:,i)); title('Baseline removed'); xlabel('[sec]');
ylabel('A.U.');
linkaxes(ax,'x');
hold off; grid on;
end
end
end

if(Aff==1)
figure
plot((1:length(PPG(:,1)))/fs,PPG(:,1),'b',(1:length(PPG(:,1)))/fs,PPGf(:,1),'r'); grid on; 
title('Red: filtered PPG');
end

end 
% --------------------------------
% %Rponse en amplitude
% hba = freqz(B,A,2000);
% fr = linspace(0,0.5,2000);
% figure
% plot(fr,abs(hba),'b'); title('Reponse en amplitude');