
%function [alarmResult,FEATURES,QI] = challenge(recordName,alarm_type)
function [alarmResult] = challenge(recordName,alarm_type)

% Load the classifier for asystole processing
classifiers = [];
load('classifier_asys.mat');
classifiers.cls = cls;
%load('classifier_vtach_2.mat');
%classifiers.cls2 = cls;

FEATURES = [];

% Return an alarm result for each type of arrhythmia 
switch alarm_type
   
            case 'Ventricular_Tachycardia'
              [alarmResult, QI, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,1); 
             
            case 'Asystole' 
                
              [ar1, QI1]=Challenge_Sasan_Asystole(recordName,alarm_type,0); 
              [ar2, QI2, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,1);
              vote=[];
              if(QI1.qualityII), vote=[vote; QI1.II;]; end
              if(QI1.qualityV), vote=[vote; QI1.V;]; end
              if(QI2.qualityPPG), vote=[vote; QI2.PPG]; end
              if(QI2.qualityABP), vote=[vote; QI2.ABP]; end              
              v_false=find(vote==0);
              if(~isempty(v_false))
                  alarmResult=0;
              else
                  alarmResult=1;
              end
              
            case 'Tachycardia'
              [alarmResult, QI, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,0);
              
            case 'Bradycardia'
               
              [alarmResult, QI, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,0); 
              if((QI.qualityPPG == 0) && (QI.qualityABP == 0))
                  [alarmResult, QI]=Challenge_Sasan_new_rules(recordName,alarm_type,0);
              end  
                 
            case 'Ventricular_Flutter_Fib'
              [alarmResult, QI, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,0);
    otherwise
        alarmResult=1;
end
     
% Write result to answers.txt -----
answers = 'answers.txt';
fid = fopen(answers, 'a');
if (fid == -1)
    error('Could not open answer file');
end

% Get base name of record (without directories)
i = strfind(recordName, filesep);
if (~isempty(i))
    basename = recordName(i(end)+1 : end);
else
    basename = recordName;
end

fprintf(fid, '%s,%d\n', basename, alarmResult);
fclose(fid);
end
% -------------------------------
           



