function [weights,omega,X] = OSC_ANF_weight(U,f0,beta,delta,mu);

% U signaux d'entre (colonnes)
% beta coef. rsonance filtre, typiquement 0.9
% delta coef. mise  jour pour oscillateur, typiquement 0.9
% mu coef. mise  jour weights, typiquement 0.9
% alpha coef. filtre
% omega pulsation
% X sorties du filtre

[N,nsig] = size(U);
weights = zeros(N,nsig);
X = U;
alpha = ones(N+1,1)*cos(2*pi*f0);
b = 0.5*(1-beta)*[1 0 -1];
a = [1 -alpha(1)*(beta+1) beta];
V = filter(b,a,X);
Q = mean(V(2:99,:).*(V(1:98,:)+V(3:100,:)),1);
P = mean(V(1:100,:).^2,1);
J = V(3:100,:)-2*alpha(1)*V(2:99,:)+V(1:98,:);
J = mean(J.*J,1);
S = mean((U(1:100,:)).^2,1);
W = S./J;
% W(1) = 0.4*W(1);
% W(2) = 0.6*W(2);
weights(1,:) = W/sum(W);
weights(2,:) = W/sum(W);
for n=3:N,
    % calcul sortie du filtre
    X(n,:) = alpha(n)*(beta+1)*X(n-1,:) - beta*X(n-2,:) + 0.5*(1-beta)*(U(n,:)-U(n-2,:));
    Q = delta*Q + (1-delta)*(X(n-1,:).*(X(n,:)+X(n-2,:)));
    P = delta*P + (1-delta)*X(n-1,:).*X(n-1,:);
    J = mu*J + (1-mu)*(X(n,:) -2*alpha(n)*X(n-1,:)+X(n-2,:)).^2;
    S = mu*S + (1-mu)*U(n,:).^2;
    W = S./J;
    weights(n,:) = W/sum(W);
    alpha(n+1) = 0.5*weights(n,:)*(Q./P)';

end

alpha = alpha(1:end-1);
alpha = alpha.*(abs(alpha)<1)+1.0*(alpha>=1)-1.0*(alpha<=-1);
omega = acos(alpha);


   
    