function [alpha,omega,X] = OSC_ANF_comp_weight(U,f0,beta,delta,mode);
% [alpha,omega,X] = OSC_ANF_comp_weight(U,f0,beta,delta,mode);
% U signaux d'entre (colonnes)
% f0 frequence normalisee initiale
% beta coef. rsonance filtre, typiquement 0.9
% delta coef. mise  jour pour oscillateur et coef., typiquement 0.9
% mode 1:ponderation SNR, 2: ponderation critere
% alpha coef. filtre
% omega pulsation
% X sorties du filtre

U = hilbert(U);
[N,d] = size(U);
X=U;
alpha = ones(N+1,1)*exp(j*2*pi*f0);
V = filter(1-beta,[1,-beta*alpha(1)],X);
Q = mean(V(2:N,:).*conj(V(1:N-1,:)),1);
P = mean(abs(V.^2),1);
Tpow = mean(abs(U(1:50,:)).^2,1);
pow = Tpow;
crit = zeros(1,d);

for n=2:N,   
    % calcul sortie du filtre
    X(n,:) = beta*alpha(n)*X(n-1,:) + (1-beta)*U(n,:);
    % calcul termes
    Q = delta*Q + (1-delta)*X(n,:).*conj(X(n-1,:));
    P = delta*P + (1-delta)*abs(X(n-1,:)).^2;
    % update valeurs pour coef
    Tpow = delta*Tpow + (1-delta)*abs(U(n,:)).^2;
    pow = delta*pow + (1-delta)*abs(X(n,:)).^2;
    crit = delta*crit + (1-delta)*abs(X(n,:)-alpha(n)*X(n-1,:)).^2;
    if mode==1,
        coef = pow./Tpow;
    else
        coef = crit./pow;
    end
    Inter = angle(Q./P);
    Inter = sum(coef.*Inter)/sum(coef);
    alpha(n+1) = exp(j*Inter);
end

alpha = alpha(1:end-1);
omega = angle(alpha);
X = real(X);




   
    