function [Heartbeats,nfrac,onsets,maximas,RR] = HeartBeatsPPG(PPG,fs,Aff,K)
Heartbeats=[];

if(nargin ==3)
    K = 2.5;
end

y = diff(PPG); y= y(:); y = [0; y];
y = -y;

theta = zeros(size(y));
alpha = 1/32;

y_env = [];
for k=1:length(y(:,1))
    y_env(k) = min(y(k),0);
end

for j =2:length(y(:,1))
    theta(j) = alpha*y_env(j)+(1-alpha)*theta(j-1);
end
        
ind = find(y(:) < K*theta(:));
new = zeros(length(theta(:)),1);
new(ind) = y(ind);
new = [new;0];


[PKS,LOCS]= findpeaks(-new,'MinPeakDistance',(0.3*fs)) ;
%[PKS,LOCS]= findpeaks(-new,'MinPeakDistance',(0.3*fs),'MinPeakHeight',0.01) ;

Heartbeats(1:length(LOCS)) = LOCS;

% Interpolation part ---------------------
nfrac = zeros(size(Heartbeats));
for i=1:length(Heartbeats)
    if(Heartbeats(i)>1 & Heartbeats(i)<length(y)-1)
nfrac(i) = y(Heartbeats(i)-1)-y(Heartbeats(i)+1);
nfrac(i) = nfrac(i)/(2*(y(Heartbeats(i)+1) - 2*y(Heartbeats(i)) + y(Heartbeats(i)-1)));
    end
end

% Onsets and maximas -----------
onsets = []; maximas = [];
%l1 = 20;
l1 = round(fs/5);

for i=1:length(Heartbeats)
    if(Heartbeats(i)>l1+1)
    [~,i1] = min(PPG(Heartbeats(i)-l1:Heartbeats(i)));
    onsets(i) = Heartbeats(i)-(l1-i1+1);
    else
        onsets(i) = Heartbeats(i);
    end
end
    

for i=1:length(onsets)-1
        if(Heartbeats(i)<length(y)-l1)
    [~,i2] = max(PPG(Heartbeats(i):onsets(i+1)));
    maximas(i) = Heartbeats(i)+i2-1;
    
    if(PPG(maximas(i)+1)>PPG(maximas(i)))
    maximas(i) = 999;
    end
    
    else
        maximas(i) = Heartbeats(i);
    end
    
end

temp = find(maximas ~= 999);
maximas = maximas(temp);

% ------------------------------

% RR Serie
RR = [];
NewHeartbeats = (Heartbeats + nfrac)/fs;
RR = diff(NewHeartbeats);
RR = RR * 1000; % en ms

% -------------------------------

if(Aff ==1)
figure 
plot(y(:)); hold on;
plot(LOCS,y(LOCS),'r*'); hold off;

figure
ax1(1) = subplot(211);
plot(PPG(:,1)); grid on; title('PPG');
hold on;
plot(Heartbeats(:),PPG(Heartbeats(:)),'r*'); hold off;
ax1(2) = subplot(212);
plot(K*(theta),'m'); grid on;
hold on;
plot(y(:));
linkaxes(ax1,'x');

figure
ax1(1) = subplot(211);
plot(PPG(:,1)); grid on; title('PPG');
hold on;
plot(Heartbeats(:),PPG(Heartbeats(:)),'r*',onsets,PPG(onsets),'mo',maximas,PPG(maximas),'go'); hold off;
ax1(2) = subplot(212);
plot(K*(theta),'m'); grid on;
hold on;
plot(y(:));
linkaxes(ax1,'x');

end

end

