function [alarmResult, QI, FEATURES]=Challenge_Sibylle_code(recordName,alarm_type,classifiers,Aff)
disp('Latest version of the code!');
set(0, 'defaulttextfontsize', 22); set(0, 'defaultaxesfontsize', 22);
%  alarmResult=challenge(recordName,alarm_type)
%
% Sample entry for the 2015 PhysioNet/CinC Challenge.
%
% Inputs:
%   recordName
%       String specifying the record name to process
%   alarmType
%       String specifying the alarm type. Alarm types are:
%             Asystole, Bradycardia, Tachycardia,
%             Ventricular_Tachycardia, Ventricular_Flutter
%
% Outputs:
%   alarmResult
%       Integer value where 0 = false alarm and 1 is a true
%       alarm. 
% Written by Sibylle Fallet, July, 2015

% Name of file containing answers
%answers = 'answers.txt';
QI = []; 
QI.PPG = 1; QI.ABP = 1;
QI.qualityPPG = 0; QI.qualityABP = 0;
FEATURES = zeros(1,4);
Retrospective = 0;

%Get all ECG, blood pressure and photoplethysmogram signals
[~,signal,Fs,siginfo]=rdmat(recordName);
alarmResult=1;
description=squeeze(struct2cell(siginfo));

disp('DESCRIPTION');
disp(description);

description=description(4,:);

disp('DESCRIPTION');
disp(description);
disp('DESCRIPTION ECG');
disp(description(1:2));
tf1 = strcmp(description(1),'II');
tf2 = strcmp(description(2),'V');

[ecg_ind1,ecg_ind2,ppg_ind,abp_ind,RESP]=ChannelDetector( description ) ;

% Resample signal to 125Hz
Fs=Fs(1);
if Fs~=125
    signal=resample(signal,125,Fs);
    Fs=125;
end

%Run WABP on the record, which by default will analyze the first ABP, ART, or BP signal
% abp_ind=get_index(description,'ABP');
ann_abp=[]; ann_abp_ref=[]; BEATQ=[];

% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

if(~isempty(abp_ind))   
    ann_abp_ref=wabp(signal(:,abp_ind),0,1); % original beat detection, only for the figure 
    % Heart beats detection ---
   [av_abp, ~] = Moving_Average(signal(:,abp_ind),5);
   [~,~,~,maximas_abp,~] = HeartBeatsPPG(av_abp,Fs,0,2.5); 
   ann_abp = maximas_abp(:);
    
   % Analyze the signal quality index of ABP using jSQI
   if length(ann_abp)>=3 % at least 3 abp beats detected
        [features] = abpfeature(signal(:,abp_ind),ann_abp);
        [BEATQ, ~] = jSQI(features, ann_abp, signal(:,abp_ind));
   end
else
    disp('No ABP for this tape');
end

%Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
% ppg_ind=get_index(description,'PLETH');
ann_ppg=[]; ann_ppg_ref=[];
if (~isempty(ppg_ind))
    y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);
    ann_ppg_ref=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120); % % original beat detection, only for the figure
    %Heart beats detection  ---
    [~,~,~,maximas,~] = HeartBeatsPPG(signal(:,ppg_ind),Fs,0,2.6);
    ann_ppg = maximas(:); 
        
    % Analyze the signal quality index of PPG 
    if ~isempty(ann_ppg)
        [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
    end
end

% select the beats in the segment ----
n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));

% ---------- DISPLAY --------------------------
% if(Aff==1)
%  figure(1)
%  ax(1) = subplot(311);
%  plot((N0_d:N_d)/Fs,signal(N0_d:N_d,[ecg_ind1 ecg_ind2]),'k','LineWidth',1.3);
%  grid on; title('ECG'); ylabel('mV');
%  if(~isempty(ppg_ind))
%  ax(2) = subplot(312);
%  %plot((N0_d:N_d)/Fs,signal(N0_d:N_d,ppg_ind),ann_ppg(n_ppg_beats)/Fs,signal(ann_ppg(n_ppg_beats),ppg_ind),'r*',ann_ppg_ref(n_ppg_beats_ref)/Fs,signal(ann_ppg_ref(n_ppg_beats_ref),ppg_ind),'k*');
%  plot((N0_d:N_d)/Fs,signal(N0_d:N_d,ppg_ind),'r','LineWidth',1.3);
%  else
%  ax(2) = subplot(312);
%  plot((N0_d:N_d)/Fs,0); grid on;
%  end
%  ylabel('NU');
%  grid on; title('PPG');
%  if(~isempty(abp_ind))
%  ax(3) = subplot(313);
%  %plot((N0_d:N_d)/Fs,signal(N0_d:N_d,abp_ind),ann_abp(n_abp_beats)/Fs,signal(ann_abp(n_abp_beats),abp_ind),'r*',ann_abp_ref(n_abp_beats_ref)/Fs,signal(ann_abp_ref(n_abp_beats_ref),abp_ind),'k*');
%  plot((N0_d:N_d)/Fs,signal(N0_d:N_d,abp_ind),'b','LineWidth',1.3);
%  else
%  ax(3) = subplot(313);
%  plot((N0_d:N_d)/Fs,0); grid on;
%  end
% grid on; title('ABP'); ylabel('mmHg');
% set(ax,'XLim',[284 300]);
% linkaxes(ax,'x');
% end

%% --- CODE FOR QUALITY FROM THE AUTHORS ----------------------------------
if ~isempty(ann_abp)
    abpsqi=1-sum(sum(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:)))/numel(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:));
else
    abpsqi=0;
end
if ~isempty(ann_ppg)
    ppgsqi=mean(psqi(intersect(n_ppg_beats,1:length(psqi))));
else
    ppgsqi=0;
end

%% --- ADAPTIVE FREQUENCY TRACKING-----------------------------------------
omega = []; % Continuous Heart Rate
switch alarm_type
case 'Bradycardia' % ------------------------------------------------------

threshlod1 = 0.5; % Quality threshold
fs2 = 15; % Waveforms are resampled at 15 Hz prior to adaptive frequency tracking
f0 = 0.8/fs2; % Normalized initial frequency (48 BPM)
delta = 0.87; beta = 0.87; mode = 2; % Parameters for adaptive frequency tracking

% IF the quality of PPG and ABP is higher than threshlod 1, both are used
% to compute HR
if ((~isempty(ppg_ind) && ppgsqi > threshlod1) && (~isempty(abp_ind) && abpsqi > threshlod1))

    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,5,1,0);
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0);
    PPG = resample(PPG_temp,fs2,Fs);  ABP = resample(ABP_temp,fs2,Fs);
    [trans_PPG1, ~] = Moving_Average(PPG(:),3); % Filtered version of the PPG signal
    [trans_PPG2, ~] = Moving_Average(PPG(:),5); % Filtered version of the PPG signal
    [trans_PPG3, ~] = Moving_Average(PPG(:),11); % Filtered version of the PPG signal
    trans_PPG = [trans_PPG1(:) trans_PPG2(:) trans_PPG3(:)];    
    [trans_ABP, ~] = Moving_Average(ABP(:),7);
    
    [~,omega,~] = OSC_ANF_comp_weight([PPG(:) ABP(:) trans_PPG trans_ABP(:)],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2; % HR in BPM
    
% IF only the quality of PPG is higher than threshlod 1, only PPG is used
% to compute HR       
elseif(~isempty(ppg_ind) && ppgsqi > threshlod1) % ONLY PPG
    
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,0,1,0);
    PPG = resample(PPG_temp,fs2,Fs);  
    [trans_PPG1, ~] = Moving_Average(PPG(:),3);
    [trans_PPG2, ~] = Moving_Average(PPG(:),5);
    [trans_PPG3, ~] = Moving_Average(PPG(:),11);
    trans = [trans_PPG1(:) trans_PPG2(:) trans_PPG3(:)];
    [~,omega,~] = OSC_ANF_comp_weight([PPG(:) trans],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2; % HR in BPM
      
% IF only the quality of ABP is higher than threshlod 1, only ABP is used
% to compute HR    
elseif(~isempty(abp_ind) && abpsqi > threshlod1)
   
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0); 
    ABP = resample(ABP_temp,fs2,Fs);
    [trans, ~] = Moving_Average(ABP(:),7);
    [~,omega,~] = OSC_ANF_comp_weight([trans(:) ABP(:)],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2;  % HR in BPM
end

case 'Asystole' %----------------------------------------------------------
    
threshlod1 = 0.5; % Quality threshold
fs2 = 15; % Waveforms are resampled at 15 Hz prior to adaptive frequency tracking
f0 = 0.8/fs2; % Normalized initial frequency (48 BPM)
delta = 0.8; beta = 0.8; mode = 2; % Parameters for adaptive frequency tracking
%%
% IF the quality of PPG and ABP is higher than threshlod 1, both are used
% to compute HR
if ((~isempty(ppg_ind) && ppgsqi > threshlod1) && (~isempty(abp_ind) && abpsqi > threshlod1))
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:end,ppg_ind)),Fs,5,1,0);
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:end,abp_ind)),Fs,0,1,0);
    
    disp('LENGTH (sec)'); disp(length(PPG_temp)/Fs);
    if(length(PPG_temp)/Fs > 30)
    Retrospective = 1;
    end
        
    PPG = resample(PPG_temp,fs2,Fs);  ABP = resample(ABP_temp,fs2,Fs);
    [trans_PPG, ~] = Moving_Average(PPG(:),3);
    [trans_ABP, ~] = Moving_Average(ABP(:),3);
    [~,omega,~] = OSC_ANF_comp_weight([PPG(:) ABP(:) trans_PPG(:) trans_ABP(:)],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2; % HR in BPM
    
% IF only the quality of PPG is higher than threshlod 1, only PPG is used
% to compute HR             
elseif(~isempty(ppg_ind) && ppgsqi > threshlod1) % ONLY PPG
    
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:end,ppg_ind)),Fs,5,1,0);
    disp('LENGTH (sec)'); disp(length(PPG_temp)/Fs);
    if(length(PPG_temp)/Fs > 30)
    Retrospective = 1;
    end
    
    PPG = resample(PPG_temp,fs2,Fs);   
    [trans, ~] = Moving_Average(PPG(:),3);
    [~,omega,~] = OSC_ANF_comp_weight([PPG(:) trans(:)],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2; % HR in BPM
   
% IF only the quality of ABP is higher than threshlod 1, only ABP is used
% to compute HR  
elseif(~isempty(abp_ind) && abpsqi > threshlod1)
   
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:end,abp_ind)),Fs,0,1,0);
    disp('LENGTH (sec)'); disp(length(ABP_temp)/Fs);
    if(length(ABP_temp)/Fs > 30)
    Retrospective = 1;
    end
    
    ABP = resample(ABP_temp,fs2,Fs);
    [trans, ~] = Moving_Average(ABP(:),3); 
    [~,omega,~] = OSC_ANF_comp_weight([trans(:) ABP(:)],f0,beta,delta,mode);
    omega = omega/2/pi*60*fs2; % HR in BPM
      
end

case 'Tachycardia' %-------------------------------------------------------
                
threshlod1 = 0.6; % Quality threshold
fs2 = 35; % Waveforms are resampled at 35 Hz prior to adaptive frequency tracking
f0 = 1.35/fs2; % Normalized initial frequency (81 BPM)

delta = 0.9; beta = 0.89; mu = 0.89; % Parameters for adaptive frequency tracking

% IF the quality of PPG and ABP is higher than threshlod 1, both are used
% to compute HR
if ((~isempty(ppg_ind) && ppgsqi > threshlod1) && (~isempty(abp_ind) && abpsqi > threshlod1))

    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,5,1,0);
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0);   
    PPG = resample(PPG_temp,fs2,Fs);  ABP = resample(ABP_temp,fs2,Fs);
    [~,omega,~] = OSC_ANF_weight([PPG(:) ABP(:)],1/fs2,beta,delta,mu);
    omega = omega/2/pi*60*fs2; % HR in BPM
    
% IF only the quality of PPG is higher than threshlod 1, only PPG is used
% to compute HR      
elseif(~isempty(ppg_ind) && ppgsqi > threshlod1) % ONLY PPG
    
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,0,1,0);
    PPG = resample(PPG_temp,fs2,Fs);   
    trans = Moving_Average(PPG(:),5);
    [~,omega,~] = OSC_ANF_weight([PPG(:) trans(:)],f0,beta,delta,mu);
    omega = omega/2/pi*60*fs2; % HR in BPM
      
% IF only the quality of ABP is higher than threshlod 1, only ABP is used
% to compute HR      
elseif(~isempty(abp_ind) && abpsqi > threshlod1)
   
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0);    
    ABP = resample(ABP_temp,fs2,Fs); 
    [trans, ~] = Moving_Average(ABP(:),7);
    [~,omega,~] = OSC_ANF_weight([trans(:) ABP(:)],f0,beta,delta,mu);
    omega = omega/2/pi*60*fs2; % HR in BPM     
end

case {'Ventricular_Tachycardia'} 
threshlod1 = 0.5; % Quality threshold 
fs2 = 35;  
f0 = 1; % f0 is very high because we are looking for flutter/fib
delta = 0.9; beta = 0.89; mu = 0.89; % Parameters for adaptive frequency tracking

% ANALYSIS OF ECG WAVEFORMS -----------------------------------------------

if (~isempty(ecg_ind1) && ~isempty(ecg_ind2))
        ECG = signal(N_d-Fs*20+1:N_d,[ecg_ind1 ecg_ind2]);  
        
%        if((sum(ECG(:,1)) ~=0) && (sum(ECG(:,2)) ~=0))
        
        ECG_or = ECG;
        
%         % To replace NaN values 
%         ind1 = find(isnan(ECG(:,1))); ECG(ind1,1) = 0;
%         ind2 = find(isnan(ECG(:,2))); ECG(ind2,2) = 0;
%         % -------
        
        Cuttoff=40; Wp=(Cuttoff/Fs)*2; % Cuttoff frequency to filter ECG
        b=fir1(100,Wp); a=1;
        ECG(:,1) = filtfilt(b,a,ECG(:,1)); ECG(:,2) = filtfilt(b,a,ECG(:,2));
        ECG = zscore(ECG); 
        ECG = resample(ECG,fs2,Fs);
        [trans1, ~] = Moving_Average(ECG(:,1),5);
        [trans2, ~] = Moving_Average(ECG(:,2),5);
        [~, SPI_smooth, ~] = PPG_Spectral_Purity_recursive([trans1(:) trans2(:)],fs2,0,2*fs2);  
             
%FIGURE FOR THE CINC PAPER
% FIGURE FOR THE CINC PAPER
%         ax(1) = subplot(2,2,1);
%         plot((1:length(ECG_or))/Fs,ECG_or(:,1),'b','LineWidth',1.3); 
%         grid on; title('ECG (lead II)');  ylabel('mV');
%         ax(2) = subplot(2,2,2);
%         plot((1:length(ECG_or))/Fs,ECG_or(:,2),'r','LineWidth',1.3); 
%         grid on; title('ECG (lead V)');  ylabel('mV');
%         ax(3) = subplot(2,2,3);
%         plot((1:length(SPI_smooth(:,1)))/fs2,SPI_smooth(:,1),'b','LineWidth',1.3); 
%         grid on; title('SPI index'); xlabel('Time [sec]');
%         set(ax,'XLim',[5 20]); set(gca,'YLim',[0 1]);
%         ylabel('NU.');
%         ax(4) = subplot(2,2,4);
%         plot((1:length(SPI_smooth(:,1)))/fs2,SPI_smooth(:,2),'r','LineWidth',1.3); 
%         grid on; title('SPI index'); xlabel('Time [sec]');
%         set(ax,'XLim',[5 20]); set(gca,'YLim',[0 1]);
%         ylabel('NU.');
%         linkaxes(ax,'x');
         
        %end
end

% ANALYSIS OF ABP AND PPG WAVEFORMS ---------------------------------------
% IF the quality of PPG and ABP is higher than threshlod 1, both are used
% to compute HR
if ((~isempty(ppg_ind) && ppgsqi > threshlod1) && (~isempty(abp_ind) && abpsqi > threshlod1))
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,5,1,0);
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0);
    PPG = resample(PPG_temp,fs2,Fs);  ABP = resample(ABP_temp,fs2,Fs);   
    [~,omega,~] = OSC_ANF_weight([PPG(:) ABP(:)],1/fs2,beta,delta,mu);
    omega = omega/2/pi*60*fs2;  
    
% IF only the quality of PPG is higher than threshlod 1, only PPG is used
% to compute HR      
elseif(~isempty(ppg_ind) && ppgsqi > threshlod1) % ONLY PPG   
    [PPG_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,ppg_ind)),Fs,0,1,0);
    PPG = resample(PPG_temp,fs2,Fs);   trans = atan(PPG(:));
    [~,omega,~] = OSC_ANF_weight([PPG(:) trans(:)],f0,beta,delta,mu);
    omega = omega/2/pi*60*fs2;
    
% IF only the quality of ABP is higher than threshlod 1, only ABP is used
% to compute HR      
elseif(~isempty(abp_ind) && abpsqi > threshlod1)
    [ABP_temp, ~] = filter_PPG(zscore(signal(N_d-Fs*20+1:N_d,abp_ind)),Fs,0,1,0); 
    ABP = resample(ABP_temp,fs2,Fs);   [trans, ~] = Moving_Average(ABP(:),7);
    [~,omega,~] = OSC_ANF_weight([trans(:) ABP(:)],f0,beta,delta,mu);
    omega = omega/2/pi*60*fs2;    
end   
    
case {'Ventricular_Flutter_Fib'}        
fs2 = 35;  % Resampling of ECG

% ECG ANALYSIS FOR THE DETECTION OF OSCILLATORY WAVEFORMS
if (~isempty(ecg_ind1) && ~isempty(ecg_ind2))
    ECG = signal(N_d-Fs*20+1:N_d,[ecg_ind1 ecg_ind2]);  
    Cuttoff=40; Wp=(Cuttoff/Fs)*2; % Cuttoff frequency to filter ECG
    b=fir1(100,Wp); a=1;
    ECG(:,1) = filtfilt(b,a,ECG(:,1)); ECG(:,2) = filtfilt(b,a,ECG(:,2));
    ECG = resample(ECG,fs2,Fs);  
   [trans1, ~] = Moving_Average(zscore(ECG(:,1)),5);
   [trans2, ~] = Moving_Average(zscore(ECG(:,2)),5);
   [~, SPI_smooth_fib, ~] = PPG_Spectral_Purity_recursive([trans1(:) trans2(:)],fs2,Aff,2*fs2);    
end     
end

%% ------------------------------ SUPRESSION OF FALSE ALARMS --------------
switch alarm_type
    case 'Asystole' %------------------------------------------------------
    disp('Looking for asystole')
        sqi_th0 = 0.6; % Threshold for the quality of ABP and PPG                  
 % New rules for retrospective----
            if (abpsqi>=sqi_th0 && ~isempty(omega)) || (ppgsqi>=sqi_th0 && ~isempty(omega)) 
             
             if(Retrospective == 0)
             omega_mean = mean(omega(15*fs2:end)); % in the 5 last seconds
             d_omega = omega(round(16*fs2))-omega(round(20*fs2));
             else
             omega_mean = mean(omega(15*fs2:23*fs2)); % use 3 more sec
             d_omega = omega(round(16*fs2))-omega(round(22*fs2));
             end
             
             FEATURES(1) = omega_mean;
             FEATURES(2) = d_omega;
             alarmResult = predict(classifiers.cls,[FEATURES(1) FEATURES(2)]);
            end
            
            % Quality output for the voting part in challenge.m            
            if(abpsqi>=sqi_th0)
                QI.qualityABP = 1;
            end
            if(ppgsqi>=sqi_th0)
                QI.qualityPPG = 1;
            end


    case 'Bradycardia' %---------------------------------------------------
    disp('Looking for bradycardia')
        sqi_th0 = 0.5; % Threshold for the quality of ABP and PPG
        debut = 15; % Sec
        limit = 54; % BPM
        
         if (abpsqi>=sqi_th0 && ~isempty(omega)) || (ppgsqi>=sqi_th0 && ~isempty(omega))
             omega_mean = mean(omega(debut*fs2:end)); % 5 sec before the alarm are considered  
             omega_median = median(omega(debut*fs2:end)); % 5 sec before the alarm are considered 
                if(omega_mean > limit && omega_median > limit) % Condition to supress the alarm
                    alarmResult=0;
                end 
         end
         
     % For the quality output            
    if(abpsqi>=sqi_th0)
    QI.qualityABP = 1;
    end
    if(ppgsqi>=sqi_th0)
    QI.qualityPPG = 1;
    end    
             
    case 'Tachycardia' %---------------------------------------------------
    disp('Looking for tachycardia')
        sqi_th0 = 0.6; % Threshold for the quality of ABP and PPG
        debut = 16; % Sec
        
        if (abpsqi>=sqi_th0 && ~isempty(omega)) || (ppgsqi>=sqi_th0 && ~isempty(omega))
             omega_mean = mean(omega(debut*fs2:end)); % 4 sec before the alarm are considered        
            if(omega_mean < 90)
                alarmResult=0;
            end   
        end
        
    % For the quality output            
    if(abpsqi>=sqi_th0)
    QI.qualityABP = 1;
    end
    if(ppgsqi>=sqi_th0)
    QI.qualityPPG = 1;
    end    
               
    case 'Ventricular_Tachycardia' %---------------------------------------
    disp('Looking for ventricular tachycardia') 
        sqi_th0 = 0.6;   % Threshold for the quality of ABP and PPG
        
       % PPG & ABP : To supress the alarm if HR is too low
        if ((abpsqi>=sqi_th0 && ~isempty(omega)) || (ppgsqi>=sqi_th0 && ~isempty(omega)))           
            omega_mean = zeros(8,1); 
            for j=1:8 % To compute avergaed HR in 3 sec windows (shifted 1 sec)
                omega_mean(j) = mean(omega((10*fs2)+((j-1)*fs2):(10*fs2)+((j-1)*fs2)+(3*fs2)));
            end  
            if(max(omega_mean) < 90 && min(omega_mean) > 60) % IF HR is low, alarm can be suppressed
                alarmResult=0;
            end 
        end            
        
    if (~isempty(ecg_ind1) && ~isempty(ecg_ind2))
        %if((sum(ECG(:,1)) ~=0) && (sum(ECG(:,2)) ~=0))
                L=3; SPI_stat= zeros(15-L+1,4);
                    for j=1:15-L+1 % To compute mean and max SPI on L sec windows
                SPI_stat(j,1) = mean(SPI_smooth((5*fs2)+((j-1)*fs2):(5*fs2)+((j-1)*fs2)+(L*fs2),1));
                SPI_stat(j,2) = mean(SPI_smooth((5*fs2)+((j-1)*fs2):(5*fs2)+((j-1)*fs2)+(L*fs2),2));
                SPI_stat(j,3) = max(SPI_smooth((5*fs2)+((j-1)*fs2):(5*fs2)+((j-1)*fs2)+(L*fs2),1));
                SPI_stat(j,4) = max(SPI_smooth((5*fs2)+((j-1)*fs2):(5*fs2)+((j-1)*fs2)+(L*fs2),2));
                    end
                DMAX_II = 0; DMAX_V = 0;
                [MAX_II, indII] = max(SPI_stat(:,3)); [MAX_V, indV] = max(SPI_stat(:,4)); 
            if(indII > 2)
                DMAX_II = MAX_II - SPI_stat(indII-2,3); % Reflects an increase of SPI 
            end 
            if(indV > 2)
                DMAX_V = MAX_V - SPI_stat(indV-2,4); % Reflects an increase of SPI 
            end

            FEATURES(1) = max(SPI_stat(:,1));
            FEATURES(2) = max(SPI_stat(:,2));
            FEATURES(3) = DMAX_II; 
            FEATURES(4) = DMAX_V; 
            
            % Descision making process: BOTH  -----------------------------
            if(max(FEATURES(1:2)) < 0.25) % SPI is high during VTACH 
                QI.ECG = 0;
                alarmResult=0;
            end 
            if(max(FEATURES(3:4)) < 0.012) % Condition on increase SPI only
                QI.ECG = 0;
                alarmResult=0;
            end  
            if((max(FEATURES(3:4)) < 0.2) && (max(FEATURES(1:2))  < 0.36))        
                QI.ECG = 0;
                alarmResult=0;
            end
                        
        %end 
    end
     
                    
    case 'Ventricular_Flutter_Fib'
    disp('Looking for ventricular flutter')  
    if (~isempty(ecg_ind1) && ~isempty(ecg_ind2))     
    SPI_mean = zeros(8,2);
        for j=1:8 % 3 sec window, 1 sec overlap
            SPI_mean(j,1) = mean(SPI_smooth_fib((10*fs2)+((j-1)*fs2):(10*fs2)+((j-1)*fs2)+(3*fs2),1));
            SPI_mean(j,2) = mean(SPI_smooth_fib((10*fs2)+((j-1)*fs2):(10*fs2)+((j-1)*fs2)+(3*fs2),2));
        end      
        if(max(SPI_mean) < 0.63)
            alarmResult=0;
        end
              
    end

    otherwise
        error(['Unknown alarm type: ' alarm_type])
end

disp('Answer')
disp(alarmResult);

if(QI.qualityPPG ==1)
   QI.PPG = alarmResult;
else
   QI.PPG = 0; 
end
if(QI.qualityABP ==1)
   QI.APB = alarmResult;
else
   QI.APB = 0; 
end

end
