function [alarmResult,QI]=Challenge_Sasan_new_rules(recordName,alarm_type,Display_Res)
%
%Display_Res=1; 
consecutive=0; tolerance = 5; % tolerance = 5 bmp
%  alarmResult=challenge(recordName,alarm_type)
%
% Sample entry for the 2015 PhysioNet/CinC Challenge.
%
% Inputs:
%   recordName
%       String specifying the record name to process
%   alarmType
%       String specifying the alarm type. Alarm types are:
%             Asystole, Bradycardia, Tachycardia,
%             Ventricular_Tachycardia, Ventricular_Flutter
%
%
% Outputs:
%   alarmResult
%       Integer value where 0 = false alarm and 1 is a true
%       alarm. 
%
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% Dependencies:
%
%       1) This function does not requires that you have the WFDB
%       App Toolbox installed. 
%       A matlab function 'rdmat' can read the data instead of using WFDB
%       Toolbox.
%
%       2) The CHALLENGE function requires that you have downloaded the challenge
%       data 'set-p' in a subdirectory of the current directory. The subdirectory
%       should be called '/challenge/2015/set-p/' . The 'set-p' dataset can
%       be downloaded from PhysioNet at:
%           http://physionet.org/physiobank/database/challenge/2015/
%          
%         This dataset is used by the generateValidationSet.m script to
%         create the annotations on your traing set that will be used to 
%         verify that your entry works properly in the PhysioNet testing 
%         environment. 
%
% Version 0.5
%
%
% Written by Qiao Li, November 10, 2014.
% Last Modified: Ikaro Silva February 11, 2015
% Modified by Sasan Yazdani, March, 2015
%
%
%
% %Example using training data- 
% alarmResult=challenge('./challenge/set-p/100','Asystole')
%

% Name of file containing answers
answers = 'answers.txt';
%Get all ECG, blood pressure and photoplethysmogram signals
[~,signal,Fs,siginfo]=rdmat(recordName);
alarmResult=1;
description=squeeze(struct2cell(siginfo));
description=description(4,:);
[ecg_ind1,ecg_ind2,ppg_ind,abp_ind,RESP]=ChannelDetector( description ) ;
ppg_ind=ecg_ind1;
abp_ind=ecg_ind2;
% sqi_info

% Resample signal to 125Hz
Fs=Fs(1);
if Fs~=125
    signal=resample(signal,125,Fs);
    Fs=125;
end
tm=0:(1/Fs):size(signal,1)/Fs;
tm=tm(1:end-1);

%%creating a lowpass filter
Cuttoff=40;
Wp=(Cuttoff/Fs)*2;    % Cuttoff frequency
%FIR
b=fir1(100,Wp);
a=1;

%% ECG lead II analysis
%%Selecting the last 20 seconds of the signal
N=min(size(signal,1),Fs*5*60+5*Fs);
N0=Fs*5*60-20*Fs;
tm=tm(N0:N);
% abp_ind=get_index(description,'II');
ann_abp=[]; QI.qualityII=0;
if(~isempty(abp_ind))
    signal_curr=signal(N0:N,abp_ind);
    signal_curr=signal_curr-mean(signal_curr);
    ecg = filtfilt(b,a,signal_curr);
    ecg=ecg/max(ecg);
    %% Checking the signal quality
    [pxx,f]=pwelch(ecg,256,[],[],Fs);
    features(1)=real(sum(pxx(f>=5 & f<=15))/sum(pxx(f>=5 & f<=40)));
    features(2)=real(sum(pxx(f>=1 & f<=40))/sum(pxx(f<=40)));
    % features(3)=mean(ecg);
    % features(4)=var(ecg);
    features(3)=skewness(ecg);
    features(4)=kurtosis(ecg);
     qualityII=1;
    if(isnan(features(1)))
        features(1)=-1;
        features(2)=-1;
        features(3)=-1;
        features(4)=-1;
%           qualityII=0;
    %     features(5)=-1;
    %     features(6)=-1;
    end  
%     qualityII=svmclassify(classifier,features);
    QI.qualityII=qualityII;
    if(qualityII)
        %Initialization for peak detection 
        
        % HERE CHANGED!!!
        %[R_inds,Q_inds,S_inds,QRS_On_II,QRS_Off_II,ecg_hat,Peak_activities]=F2AMM3(ecg,Fs,1);
       [R_inds,Q_inds,S_inds,QRS_On_II,QRS_Off_II,ecg_hat,Peak_activities]=F2AMM3_old(ecg,Fs,1);
        
        ann_abp=R_inds+N0;
        if(Display_Res)
            figure(1); cla; subplot(211);
            plot(tm,ecg,'b'); hold on;
            plot(tm(R_inds),ecg(R_inds),'*r'); hold off;
            xlim([tm(1) tm(end)]);
            subplot(212);
            plot(60./(diff(R_inds)*(1/Fs)));
        end
    end
end

%% ECG lead V analysis
%Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
% ppg_ind=get_index(description,'V');
ann_ppg=[]; QI.qualityV=0;
if (~isempty(ppg_ind))    
    signal_curr=signal(N0:N,ppg_ind);
    signal_curr=signal_curr-mean(signal_curr);
    ecg = filtfilt(b,a,signal_curr);
    ecg=ecg/max(ecg);
    %% Checking the signal quality
    [pxx,f]=pwelch(ecg,256,[],[],Fs);
    features(1)=real(sum(pxx(f>=5 & f<=15))/sum(pxx(f>=5 & f<=40)));
    features(2)=real(sum(pxx(f>=1 & f<=40))/sum(pxx(f<=40)));
    % features(3)=mean(ecg);
    % features(4)=var(ecg);
    features(3)=skewness(ecg);
    features(4)=kurtosis(ecg);
     qualityV=1;
    if(isnan(features(1)))
        features(1)=-1;
        features(2)=-1;
        features(3)=-1;
        features(4)=-1;
%             qualityV=0;
    %     features(5)=-1;
    %     features(6)=-1;
    end  
%      qualityV=svmclassify(classifier,features);
    QI.qualityV=qualityV;
    if(qualityV) 

        %[R_inds,Q_inds,S_inds,QRS_On_V,QRS_Off_V,ecg_hat,Peak_activities]=F2AMM3(ecg,Fs,1);
        [R_inds,Q_inds,S_inds,QRS_On_V,QRS_Off_V,ecg_hat,Peak_activities]=F2AMM3_old(ecg,Fs,1);
        
        ann_ppg=R_inds+N0;
        if(Display_Res)
            if(isempty(abp_ind)), cla; end
            figure(1); subplot(211); hold on;
            plot(tm,ecg,'g');
            plot(tm(R_inds),ecg(R_inds),'*k'); hold off;
            xlim([tm(1) tm(end)]);
            subplot(212); hold on;
            plot(60./(diff(R_inds)*(1/Fs)),'k'); hold off;
        end
    end
end

%Make decisions ---- ORIGINAL

% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

% select the beats in the segment
n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));

hr_max_abp=NaN;
max_rr_abp=NaN;
hr_max_ppg=NaN;
max_rr_ppg=NaN;

% calculate the heart rate
if length(n_abp_beats)>=2
    hr_max_abp=60*Fs/min(diff(ann_abp(n_abp_beats)));
    max_rr_abp=max(diff(ann_abp(n_abp_beats)))/Fs;
end
if length(n_ppg_beats)>=2
    hr_max_ppg=60*Fs/min(diff(ann_ppg(n_ppg_beats)));
    max_rr_ppg=max(diff(ann_ppg(n_ppg_beats)))/Fs;
end
    
% calculate low heart rate of 5 consecutive beats for Bradycardia
low_hr_abp=NaN;
low_hr_ppg=NaN;
if length(n_abp_beats)>=5
    for i=1:length(n_abp_beats)-4
        low_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+4))-ann_abp(n_abp_beats(i)))/4);
    end
end
low_hr_abp=min(low_hr_abp);
if length(n_ppg_beats)>=5
    for i=1:length(n_ppg_beats)-4
        low_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+4))-ann_ppg(n_ppg_beats(i)))/4);
    end
end
low_hr_ppg=min(low_hr_ppg);
        
% calculate high heart reate of 17 consecutive beats for Tachycardia
high_hr_abp=NaN;
high_hr_ppg=NaN;
if length(n_abp_beats)>=17
    for i=1:length(n_abp_beats)-16
        high_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+16))-ann_abp(n_abp_beats(i)))/16);
    end
end
high_hr_abp=max(high_hr_abp);
if length(n_ppg_beats)>=17
    for i=1:length(n_ppg_beats)-16
        high_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+16))-ann_ppg(n_ppg_beats(i)))/16);
    end
end
high_hr_ppg=max(high_hr_ppg);

%% Checking for arrhythmia
% set valid data segment for decision making, 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d=N_d-Fs*16+1; % 16s before the alarm

% select the beats in the segment
n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));


hr_max_abp=NaN;
max_rr_abp=NaN;
hr_max_ppg=NaN;
max_rr_ppg=NaN;
each_rr_ppg=NaN;
each_hr_ppg=NaN;
each_rr_abp=NaN;
each_hr_abp=NaN;

Brady_ppg_check = 1;
Brady_abp_check=1;
Tachy_ppg_check=1;
Tachy_abp_check=1;
asys_ppg_check = 1;
asys_abp_check = 1;
VTachy_abp_check = 1;
VTachy_ppg_check = 1;

% calculate the heart rate
if length(n_abp_beats)>=2
    onset_abp=n_abp_beats(1);
    hr_max_abp=60*Fs/min(diff(ann_abp(n_abp_beats)));
    each_hr_abp=60*Fs./diff(ann_abp(n_abp_beats));
    max_rr_abp=max(diff(ann_abp(n_abp_beats)))/Fs;
    each_rr_abp=diff(ann_abp(n_abp_beats))./Fs;
end
if length(n_ppg_beats)>=2
    onset_ppg=n_ppg_beats(1);
    hr_max_ppg=60*Fs/min(diff(ann_ppg(n_ppg_beats)));
    each_hr_ppg=60*Fs./diff(ann_ppg(n_ppg_beats));
    max_rr_ppg=max(diff(ann_ppg(n_ppg_beats)))/Fs;
    each_rr_ppg=diff(ann_ppg(n_ppg_beats))./Fs;
end
    
area_start_ind_ppg=[];
area_stop_ind_ppg=[];
area_start_ind_abp=[];
area_stop_ind_abp=[];
hr_area_start_ind_ppg=[];
hr_area_stop_ind_ppg=[];
hr_area_start_ind_abp=[];
hr_area_stop_ind_abp=[];

%% Producing results
% Alarm threshold (seconds)
ASY_th = 4;
BRA_th = 40;
TAC_th = 140;
VTA_th = 100;
VFB_th = 250;
% tolerance = 5; % tolerance = 5 bmp %already defined

% calculate the signal quality index
ppgsqi=1;
abpsqi=1;
% SQI threshold
sqi_th = 0.9;


asys_abp_check=0; asys_ppg_check=0;
switch alarm_type
    case 'Asystole'
        
        if ((max_rr_abp<ASY_th) || (max_rr_ppg<ASY_th))
            alarmResult=0;
            asys_ppg_check = 0;
            asys_abp_check = 0;
        end        
    case 'Bradycardia'
            disp(low_hr_abp);
            disp(low_hr_ppg);
        if ((low_hr_abp-tolerance>BRA_th) && (low_hr_ppg-tolerance>BRA_th))    
            alarmResult=0;
            Brady_ppg_check = 0;
            Brady_abp_check = 0;
        end
    case 'Tachycardia'
        % if the signal quality is good enough and the high heart rate
        % is less than the Tachycardia threshold, set the alarm as 'F'
        if(~isempty(abp_ind) && qualityII && Tachy_abp_check==0 )
            alarmResult=0;
        end
        if(~isempty(ppg_ind) && qualityV && Tachy_ppg_check==0)
            alarmResult=0;
        end                 
    case 'Ventricular_Tachycardia'
        if (hr_max_abp+tolerance<VTA_th) || (hr_max_ppg+tolerance<VTA_th)
        VTachy_abp_check = 0;
        VTachy_ppg_check = 0;
        alarmResult=0;
         end
           
    case 'Ventricular_Flutter_Fib'
        % suppress false alarm using hr_max & sqi
        QI.II_VF=1;
        QI.V_VF=1;
        if (~isempty(abp_ind) && qualityII && hr_max_abp+tolerance<VFB_th)
            alarmResult=0;
            QI.II_VF=0;
        end
        if (~isempty(ppg_ind) && qualityV && hr_max_ppg+tolerance<VFB_th)
            alarmResult=0;
            QI.V_VF=0;
        end
    otherwise
        error(['Unknown alarm type: ' alarm_type])

end

        disp('Result');
        disp(alarmResult);

if(alarmResult==1 && Display_Res)
    figure(1); hold on; subplot(211);
    if(VTachy_ppg_check || Tachy_ppg_check || Brady_ppg_check || asys_ppg_check)
        subplot(211);
        vfill([area_start_ind_ppg area_stop_ind_ppg],'b','FaceAlpha',0.3,'LineStyle','none','bottom');    
        subplot(212);
        vfill([hr_area_start_ind_ppg hr_area_stop_ind_ppg],'b','FaceAlpha',0.3,'LineStyle','none','bottom');
    end
    if(VTachy_abp_check || Tachy_abp_check || Brady_abp_check || asys_abp_check)
        subplot(211);
        vfill([area_start_ind_abp area_stop_ind_abp],'r','FaceAlpha',0.3,'LineStyle','none','bottom');    
        subplot(212);
        vfill([hr_area_start_ind_abp hr_area_stop_ind_abp],'r','FaceAlpha',0.3,'LineStyle','none','bottom');
    end  
    pause(0.0000000001);
    hold off;
end

% Write result to answers.txt-----
% fid = fopen(answers, 'a');
% if (fid == -1)
%     error('Could not open answer file');
% end
% 
% % Get base name of record (without directories)
% i = strfind(recordName, filesep);
% if (~isempty(i))
%     basename = recordName(i(end)+1 : end);
% else
%     basename = recordName;
% end
% 
% fprintf(fid, '%s,%d\n', basename, alarmResult);
% fclose(fid);
% ---------------------------------
end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
        break;
    end
end
end
