function [alarmResult,QI]=Challenge_Sasan_Asystole(recordName,alarm_type,Display_Res)
% ECG analysis for asystole alarms.
% ECG peaks are dected using the F2AMM algorithm 
% Written by Sasan Yazdani

%% Reading record and extracting channels

answers = 'answers.txt';
%Get all ECG, blood pressure and photoplethysmogram signals
[~,signal,Fs,siginfo]=rdmat(recordName);
alarmResult=1;
description=squeeze(struct2cell(siginfo));
description=description(4,:);
[ecg1_ind,ecg2_ind,ppg,abp,~]=ChannelDetector( description ) ;

%% Resample signal to 125Hz and creating time vector + signal borders
Fs=Fs(1);
if Fs~=125
    signal=resample(signal,125,Fs);
    Fs=125;
end

% Create Time vector for demonstration
tm=0:(1/Fs):size(signal,1)/Fs;
tm=tm(1:end-1);

%%Selecting the last 20 seconds of the signal
N=min(size(signal,1),Fs*5*60+5*Fs);
N0=Fs*5*60-20*Fs;
tm=tm(N0:N);

%% AMM parameters
Fixed=1;
%% Running AMM on first channel
QI.qualityII=1; %for now
R_inds1=[];
if(~isempty(ecg1_ind))
    signal_curr=signal(N0:N,ecg1_ind);
%     figure(2);
%     subplot(211);
%     plot(signal(N0:N,ppg));
%     subplot(212);
%     plot(signal(N0:N,abp));
    
    signal_curr=signal_curr-mean(signal_curr);
    ecg1=signal_curr/max(signal_curr);
%     kurt=moment(ecg1,4);
%     skew=1;%abs(moment(ecg1,3));
%     if(kurt>0.5 || skew<0.3)
%         kurt
%         skew
%         QI.qualityII=0;
%         QI.II=0;
%     end
%     seq = delineation_ABP(ecg1,80,1);
    if(QI.qualityII)
        %Initialization for peak detection        
        [R_inds,Q_inds,S_inds,QRS_On_II,QRS_Off_II,ecg_hat,Peak_activities]=F2AMM3(ecg1,Fs,Fixed,1);
        R_inds1=R_inds+N0;
        if(Display_Res)
            figure(1); cla; subplot(211);
            plot(tm,ecg1,'b'); hold on;
            %plot(tm,ecg_hat,'k');
            plot(tm(R_inds),ecg1(R_inds),'*r'); hold off;
            xlim([tm(1) tm(end)]);
            subplot(212);
            plot(60./(diff(R_inds)*(1/Fs)));
        end
    end
end

%% Running AMM on second channel
QI.qualityV=1; %for now0
R_inds2=[];
if(~isempty(ecg2_ind))
    signal_curr=signal(N0:N,ecg2_ind);
    signal_curr=signal_curr-mean(signal_curr);
    ecg2=signal_curr/max(signal_curr);
%     kurt2=moment(ecg2,4);
%     skew2=1;%abs(moment(ecg2,3));
%     if(kurt2>0.5 || skew2<0.3)
%         kurt2
%         skew2
%         QI.qualityV=0;
%         QI.V=0;
%     end
%     seq = delineation_ABP(ecg2,80,1);
    if(QI.qualityV)
        %Initialization for peak detection        
        [R_inds,Q_inds,S_inds,QRS_On_II,QRS_Off_II,ecg_hat,Peak_activities]=F2AMM3(ecg2,Fs,Fixed,1);
        R_inds2=R_inds+N0;
        if(Display_Res)
            if(isempty(ecg1_ind)), cla; end
            figure(1); subplot(211); hold on;
            plot(tm,ecg2,'g');
            plot(tm(R_inds),ecg2(R_inds),'*k'); hold off;
            xlim([tm(1) tm(end)]);
            subplot(212); hold on;
            plot(60./(diff(R_inds)*(1/Fs)),'k'); hold off;
        end
    end
end

%% Producing results
% Alarm threshold (seconds)
ASY_th = 3.5;
% tolerance = 5; % tolerance = 5 bmp %already defined
qualityII=QI.qualityII;
qualityV=QI.qualityV;
switch alarm_type
    case 'Asystole'
        RR1=[]; RR2=[];
        if(length(R_inds1)>1)
            RR1=diff(R_inds1)/Fs;
            RR1_max=max(RR1);
            Time_R1_end=tm(R_inds1(end)-N0);
        end
        if(length(R_inds2)>1)
            RR2=diff(R_inds2)/Fs;
            RR2_max=max(RR2);
            Time_R2_end=tm(R_inds2(end)-N0);
        end    
         
        if(qualityII && ~isempty(RR1) && (RR1_max<ASY_th && Time_R1_end>(300-ASY_th)))
            alarmResult=0;
            QI.II=0;
        elseif(qualityII)
            QI.II=1;
        end
        if(qualityV && ~isempty(RR2) && (RR2_max<ASY_th && Time_R2_end>(300-ASY_th)))
            QI.V=0;
            alarmResult=0;
        elseif(qualityV)
            QI.V=1;
        end
    otherwise
        error(['Different alarm type: ' alarm_type])
end

